% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/09playing_routines.r
\docType{methods}
\name{playMod}
\alias{playMod}
\alias{playMod,PTModule-method}
\title{Play PTModule objects}
\usage{
\S4method{playMod}{PTModule}(mod, wait = T, ...)
}
\arguments{
\item{mod}{A \code{\link{PTModule}} object to be played.}

\item{wait}{A \code{logical} value. When set to \code{TRUE} the playing
routine will wait with executing any code until the playing is
finished. When set to \code{FALSE}, subsequent R code will be
executed while playing.}

\item{...}{Arguments that are passed on to \code{\link{modToWave}}.}
}
\value{
A \code{\link[tuneR]{Wave}} object, generated from the
\code{mod} object, is returned.
}
\description{
Converts \code{\link{PTModule}} objects into audio
\code{\link[tuneR]{Wave}}s, and plays them.
}
\details{
Unfortunately, it was not feasible to create a routine that can directly
interpret \code{\link{PTModule}} objects and play them simultaneously.
Instead, the audio first needs to be rendered after which it can be played.
This method therefore first calls \code{\link{modToWave}} and then
\code{\link{playWave}}. Rendering may take some time and requires some
balance between speed, quality and accuracy. See the documentation of the
\code{\link{modToWave}} method for the control you have on these aspects.
}
\examples{
\dontrun{
data("mod.intro")

## play the module and capture the audio Wave
wav <- playMod(mod.intro)
}
}
\seealso{
Other play.audio.routines: \code{\link{playSample}},
  \code{\link{playWave}}

Other module.operations: \code{\link{PTModule-class}},
  \code{\link{appendPattern}}, \code{\link{clearSamples}},
  \code{\link{clearSong}}, \code{\link{deletePattern}},
  \code{\link{fix.PTModule}}, \code{\link{modToWave}},
  \code{\link{moduleSize}}, \code{\link{patternLength}},
  \code{\link{patternOrderLength}},
  \code{\link{patternOrder}}, \code{\link{playingtable}},
  \code{\link{rawToPTModule}}, \code{\link{read.module}},
  \code{\link{trackerFlag}}, \code{\link{write.module}}
}
\author{
Pepijn de Vries
}
