% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/function_dag.R
\name{dag.plot}
\alias{dag.plot}
\title{DAG plot}
\usage{
dag.plot(prec1and2 = NULL, prec3and4 = NULL, critical.activities = NULL)
}
\arguments{
\item{prec1and2}{A matrix indicating the order of precedence type 1 and 2 between the activities (Default=NULL). If value \eqn{(i,j)=1} then activity \eqn{i} precedes type \eqn{1} to \eqn{j}, and if \eqn{(i,j)=2} then activity \eqn{i} precedes type \eqn{2} to \eqn{j}. Cycles cannot exist in a project,  i.e. if an activity \eqn{i} precedes \eqn{j} then \eqn{j} cannot precede \eqn{i}.}

\item{prec3and4}{A matrix indicating the order of precedence type 3 and 4 between the activities (Default=NULL). If value \eqn{(i,j)=3} then activity \eqn{i} precedes type \eqn{3} to \eqn{j}, and if \eqn{(i,j)=4} then activity \eqn{i} precedes type \eqn{4} to \eqn{j}. Cycles cannot exist in a project,  i.e. if an activity \eqn{i} precedes \eqn{j} then \eqn{j} cannot precede \eqn{i}.}

\item{critical.activities}{A vector indicating the critical activities to represent them in a different color (Default=NULL) .}
}
\value{
A plot.
}
\description{
This function plots a directed acyclic graph (DAG).
}
\examples{

prec1and2<-matrix(c(0,1,0,2,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,2,0),nrow=5,ncol=5,byrow=TRUE)
prec3and4<-matrix(0,nrow=5,ncol=5)
prec3and4[3,1]<-3
dag.plot(prec1and2,prec3and4)
}
