% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PsychWordVec.R
\name{tab_similarity}
\alias{tab_similarity}
\title{Tabulate data for cosine similarity/distance of all word pairs.}
\usage{
tab_similarity(
  data,
  words = NULL,
  pattern = NULL,
  unique = FALSE,
  distance = FALSE
)
}
\arguments{
\item{data}{A \code{data.table} (of new class \code{wordvec})
loaded by \code{\link{data_wordvec_load}}.}

\item{words}{[Option 1] Word strings (\code{NULL}; a single word; a vector of words).}

\item{pattern}{[Option 2] Pattern of regular expression (see \code{\link[stringr:str_subset]{str_subset}}).}

\item{unique}{Word pairs: unique pairs (\code{TRUE})
or full pairs with duplicates (\code{FALSE}; default).}

\item{distance}{Compute cosine distance instead?
Defaults to \code{FALSE} (cosine similarity).}
}
\value{
A \code{data.table} of all words and
their unique or full pairs,
with their cosine similarity (\code{cos_sim})
or cosine distance (\code{cos_dist}).
}
\description{
Tabulate data for cosine similarity/distance of all word pairs.
}
\section{Download}{

Download pre-trained word vectors data (\code{.RData}):
\url{https://psychbruce.github.io/WordVector_RData.pdf}
}

\examples{
tab_similarity(demodata, cc("king, queen, man, woman"))

tab_similarity(demodata, cc("king, queen, man, woman"),
               unique=TRUE)

tab_similarity(demodata, cc("Beijing, China, Tokyo, Japan"))

tab_similarity(demodata, cc("Beijing, China, Tokyo, Japan"),
               unique=TRUE)

}
\seealso{
\code{\link{cosine_similarity}}

\code{\link{pair_similarity}}

\code{\link{most_similar}}

\code{\link{test_WEAT}}

\code{\link{test_RND}}
}
