% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_aids.R
\name{get_aids}
\alias{get_aids}
\title{Retrieve Assay IDs (AIDs) from PubChem}
\usage{
get_aids(
  identifier,
  namespace = "cid",
  domain = "compound",
  searchtype = NULL,
  as_data_frame = TRUE,
  options = NULL
)
}
\arguments{
\item{identifier}{A vector of positive integers (e.g. cid, sid, aid) or identifier strings (source, inchikey, formula). In some cases, only a single identifier string (name, smiles, xref; inchi, sdf by POST only).}

\item{namespace}{Specifies the namespace for the query. For the 'compound' domain, possible values include 'cid', 'name', 'smiles', 'inchi', 'sdf', 'inchikey', 'formula', 'substructure', 'superstructure', 'similarity', 'identity', 'xref', 'listkey', 'fastidentity', 'fastsimilarity_2d', 'fastsimilarity_3d', 'fastsubstructure', 'fastsuperstructure', and 'fastformula'. For other domains, the possible namespaces are domain-specific.}

\item{domain}{Specifies the domain of the query. Possible values are 'substance', 'compound', 'assay', 'gene', 'protein', 'pathway', 'taxonomy', 'cell', 'sources', 'sourcetable', 'conformers', 'annotations', 'classification', and 'standardize'.}

\item{searchtype}{Specifies the type of search to be performed. For structure searches, possible values are combinations of 'substructure', 'superstructure', 'similarity', 'identity' with 'smiles', 'inchi', 'sdf', 'cid'. For fast searches, possible values are combinations of 'fastidentity', 'fastsimilarity_2d', 'fastsimilarity_3d', 'fastsubstructure', 'fastsuperstructure' with 'smiles', 'smarts', 'inchi', 'sdf', 'cid', or 'fastformula'.}

\item{as_data_frame}{A logical value indicating whether to return the results as a tibble (data frame). Default is TRUE.}

\item{options}{Additional arguments passed to \code{\link{get_json}}}
}
\value{
If `as_data_frame` is TRUE, a tibble (data frame) where each row corresponds to a provided identifier and its AID.
        The tibble has columns 'CID' and 'AID'. If `as_data_frame` is FALSE, a list of AIDs is returned.
}
\description{
This function sends a request to PubChem to retrieve Assay IDs (AIDs) for a given identifier.
It returns either a tibble (data frame) with the provided identifier and the corresponding AIDs
or a list of AIDs, depending on the `as_data_frame` parameter.
}
\examples{
get_aids(
  identifier = "aspirin",
  namespace = "name"
)
}
