% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_assays.R
\name{get_assays}
\alias{get_assays}
\title{Retrieve Assays from PubChem}
\usage{
get_assays(
  identifier,
  namespace = "aid",
  operation = NULL,
  searchtype = NULL,
  options = NULL
)
}
\arguments{
\item{identifier}{A vector of positive integers (e.g. cid, sid, aid) or identifier strings (source, inchikey, formula). In some cases, only a single identifier string (name, smiles, xref; inchi, sdf by POST only).}

\item{namespace}{Specifies the namespace for the query. For the 'compound' domain, possible values include 'cid', 'name', 'smiles', 'inchi', 'sdf', 'inchikey', 'formula', 'substructure', 'superstructure', 'similarity', 'identity', 'xref', 'listkey', 'fastidentity', 'fastsimilarity_2d', 'fastsimilarity_3d', 'fastsubstructure', 'fastsuperstructure', and 'fastformula'. For other domains, the possible namespaces are domain-specific.}

\item{operation}{The operation to be performed (default: NULL).}

\item{searchtype}{The type of search to be performed (default: NULL).}

\item{options}{Additional parameters. Currently has no effect on the results.}
}
\value{
A named list where each element corresponds to an assay retrieved from PubChem.
        The names of the list elements are based on the provided identifiers.
        If no assay is found for a given identifier, the corresponding list element will contain the string "No assay".
}
\description{
This function sends a request to PubChem to retrieve assay data based on the specified parameters.
It returns a list of assays corresponding to the provided identifiers.
}
\examples{
get_assays(
  identifier = 1234,
  namespace = "aid"
)
}
