% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{ppl_plot_avg_contour}
\alias{ppl_plot_avg_contour}
\title{Plots average contour surface of pupil data.}
\usage{
ppl_plot_avg_contour(data, Column = NULL, Var = NULL,
  Averaging = "Event", VarLabel = NULL, xlim = NA,
  PupilPreTheme = TRUE, Colors = c("gray20", "gray90"))
}
\arguments{
\item{data}{A data table object output by either \code{\link{create_time_series}}.}

\item{Column}{A string specifying the column to use.}

\item{Var}{A string containing the column name corresponding to the continuous
variable.}

\item{Averaging}{A character string indicating how the averaging should
be done. "Event" (default) will produce the overall mean in the data, while
"Subject" or "Item" (or, in principle, any other column name) will
calculate the grand mean by that factor.}

\item{VarLabel}{A string specifying the axis label to use for \code{Var}.}

\item{xlim}{A vector of two integers specifying the limits of the x-axis.}

\item{PupilPreTheme}{A logical indicating whether the theme included with the
function, or ggplot2's base theme (which any other custom theme could be added).}

\item{Colors}{A vector of two strings specifying the colrs of the contour
shading - The default values represent grayscale.}
}
\description{
\code{ppl_plot_avg_contour} calculates the conditional average of pupil
size by Time and a specified continuous variable. It then applies a 3D smooth
(derived using \code{\link[mgcv]{gam}}) over the surface and plots the
results as a contour plot.
}
\examples{
# Load example data
data("Pupilex7")

ppl_plot_avg_contour(data = Pupilex7, Column = "Pupil", Var = "TRIAL_INDEX",
                     VarLabel = "Trial", xlim = c(0,2000),
                     PupilPreTheme = TRUE, Colors = c("gray20", "gray90"))

# Please see the vignettes for detailed example usage.
# vignette("PupilPre_Plotting", package="PupilPre")

}
