% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/partition_div.R
\name{partition_div}
\alias{partition_div}
\title{Diversity of cases belonging to the same partition of the pooled data}
\usage{
partition_div(dataset, units, time, cond, out, n_cut, incl_cut)
}
\arguments{
\item{dataset}{Calibrated pooled dataset that is partitioned
and minimized for deriving the pooled solution.}

\item{units}{Units defining the within-dimension of data (time series)}

\item{time}{Periods defining the between-dimension of data (cross sections)}

\item{cond}{Conditions used for the pooled analysis}

\item{out}{Outcome used for the pooled analysis}

\item{n_cut}{Frequency cut-off for designating truth table rows as
observed in the pooled data}

\item{incl_cut}{Inclusion cut-off for designating truth table rows as
consistent in the pooled data}
}
\value{
A dataframe presenting the diversity of cases belonging to the
same partition with the following columns:
\itemize{
\item \code{type}: The type of the partition. \code{pooled} are
rows with information on the pooled data; \code{between} is for
cross-section partitions; \code{within} is for time-series partitions.
\item \code{partition}: Specific dimension of the partition at hand. For
between-dimension, the unit identifiers are included here
(argument \code{units}). For the within-dimension, the time identifier
are listed (argument \code{time}). The entry is \code{-} for the
pooled data without partitions.
\item \code{diversity}: Count of all truth table rows with at least one member
belonging to a partition.
\item \code{diversity_1}: Count of consistent truth table rows with at least
one member belonging to a partition.
\item \code{diversity_0}: Count of inconsistent truth table rows with at least
one member belonging to a partition.
\item \code{diversity_per}: Ratio of the value for \code{diversity} and the
total number of truth table rows from pooled data
(\code{diversity} value for pooled data).
\item \code{diversity_per_1}: Ratio of the value for \code{diversity_1} and the
total number of consistent truth table rows from pooled data
(\code{diversity_1} value for pooled data).
\item \code{diversity_per_0}: Ratio of the value for \code{diversity_0} and the
total number of inconsistent truth table rows from pooled data
(\code{diversity_0} value for pooled data).
}
}
\description{
\code{partition_div} calculates the diversity of cases that belong to the same
partition of the clustered data (a time series; a cross section; etc.).
Diversity is measured by the number of truth table rows that the cases of
a partition cover. \code{partition_div} calculates the partition diversity
for all truth table rows and for the subsets of consistent and
inconsistent rows.
}
\examples{
data(Schwarz2016)
Schwarz_diversity <- partition_div(Schwarz2016, 
units = "country", time = "year", 
cond = c("poltrans", "ecotrans", "reform", "conflict", "attention"), 
out = "enlarge", 1, 0.8)

}
