% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LOD.QTLdetect.R
\name{LOD.QTLdetect}
\alias{LOD.QTLdetect}
\title{QTL Detect by LOD}
\usage{
LOD.QTLdetect(LOD, bin, thre = 3, QTLdist = 20, console = TRUE)
}
\arguments{
\item{LOD}{matrix. The LOD matrix which is a t*p matrix, where t is
the number of traits and p is the number of bins on the chromosomes.
The missing value should be NA.}

\item{bin}{matrix. A n*2 matrix represent how many bins on each
chromosome, where n is the number of chromosomes. The first column
denotes the chromosome number, and the second column denote how many
bins on that chromosome. Note that chromosome and must be divided
in order.}

\item{thre}{numeric. The LOD threshold. The LOD score under this
threshold will be calculated as 0.}

\item{QTLdist}{numeric. The minimum distance (bin) among different
linked significant QTL.}

\item{console}{logical. To decide whether the process of algorithm will
be shown in the R console or not.}
}
\value{
\item{detect.QTL.number}{The number of detected QTL in each trait.}
\item{QTL.matrix}{The QTL position matrix. Where the elements 1
donate the position of QTL; elements 0 donate the bins whose LOD
score is under the LOD threshold; other positions is shown as NA.}
\item{EQF.matrix}{The matrix denote the EQF value of each bin.}
\item{linkage.QTL.number}{The linkage QTL number of all detected
QTL. In other words, it is the table denote how many QTL on one
chromosome.}
\item{LOD.threshole}{The LOD threshold used in this analyze.}
\item{bin}{The bin infromation matrix used in this analyze.}
}
\description{
Detect QTL by likelihood of odds(LOD) matrix.
}
\examples{
# load the example data
load(system.file("extdata", "LODexample.RDATA", package = "QTLEMM"))
dim(LODexample) # 100 traits, 633 bins on chromosome

# run and result
result <- LOD.QTLdetect(LODexample, bin, thre = 3, QTLdist = 10)
result$detect.QTL.number

}
\references{
Wu, P.-Y., M.-.H. Yang, and C.-H. KAO 2021 A Statistical Framework
for QTL Hotspot Detection. G3: Genes, Genomes, Genetics (accepted).
}
\seealso{
\code{\link[QTLEMM]{EQF.permu}}
\code{\link[QTLEMM]{EQF.plot}}
}
