% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/progeny.R
\name{progeny}
\alias{progeny}
\title{Progeny Simulation}
\usage{
progeny(
  QTL,
  marker,
  type = "RI",
  ng = 2,
  cM = TRUE,
  E.vector = NULL,
  h2 = 0.5,
  size = 200
)
}
\arguments{
\item{QTL}{matrix. A q*2 matrix contains the QTL information, where
the row dimension q is the number of QTLs in the chromosomes. The
first column labels the chromosomes where the QTLs are located, and
the second column labels the positions of QTLs (in morgan (M) or
centimorgan (cM)). Note that chromosome and position must be divided
in order.}

\item{marker}{matrix. A k*2 matrix contains the marker information,
where the row dimension k is the number of markers in the chromosomes.
The first column labels the chromosomes where the markers are located,
and the second column labels the positions of QTLs (in morgan (M) or
centimorgan (cM)). Note that chromosome and position must be divided
in order.}

\item{type}{character. The population type of the dataset. Include
backcross (type="BC"), advanced intercross population (type="AI"), and
recombinant inbred population (type="RI").}

\item{ng}{integer. The generation number of the population type. For
example, the BC1 population is type="BC" with ng=1; the AI F3
population is type="AI" with ng=3.}

\item{cM}{logical. Specify the unit of marker position. cM=TRUE for
centi-Morgan. Or cM=FALSE for Morgan.}

\item{E.vector}{vector. Set the effect of QTLs. It should be a named
vector, and the name of elements should be the effects of QTLs and their
interaction. For example, the additive effect of QTL1 is coded to “a1”;
the dominant effect of QTL2 is coded to “d2”; and the interaction of the
additive effect of QTL2 and the dominant effect of QTL1 is coded to
“a2:d1”. So that, if the additive effect of QTL1 is 2, the dominant
effect of QTL2 is 5, and the interaction of the additive effect of QTL2
and the dominant effect of QTL1 is 3, the user should input
E.vector=c("a1"=2, "d2"=5, "a2:d1"=3). If E.vector=NULL, the phenotypic
value will not be simulated.}

\item{h2}{numeric. Set the heritability for simulated phenotypes. It
should be a number between 0 and 1.}

\item{size}{numeric. The population size of simulated progeny.}
}
\value{
\item{phe}{The phenotypic value of simulated progeny.}
\item{E.vector}{The effect vector used in this simulation.}
\item{marker.prog}{The marker genotype of simulated progeny.}
\item{QTL.prog}{The QTL genotype of simulated progeny.}
}
\description{
Generate the simulated phenotype and genotype data for a specified
generation from various breeding schemes.
}
\examples{
# load the example data
load(system.file("extdata", "exampledata.RDATA", package = "QTLEMM"))

# run and result
result <- progeny(QTL, marker, type = "RI", ng = 5, E.vector = c("a1" = 2, "d2" = 5, "a2:d1" = 3),
h2 = 0.5, size = 200)
result$phe
}
\references{
Haldane J.B.S. 1919. The combination of linkage values and the calculation
of distance between the loci for linked factors. Genetics 8: 299–309.
}
