% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QUALYPSO.r
\name{QUALYPSO.ANOVA}
\alias{QUALYPSO.ANOVA}
\title{QUALYPSO.ANOVA}
\usage{
QUALYPSO.ANOVA(phiStar, scenAvail, listOption = NULL)
}
\arguments{
\item{phiStar}{matrix of climate change responses (absolute or relative changes): \code{nS} x \code{n}. \code{n} can be the number of time steps or the number of grid points}

\item{scenAvail}{matrix of available combinations \code{nS} x \code{nEff}}

\item{listOption}{list of options (see \code{\link{QUALYPSO}})}
}
\value{
list with the following fields:
\itemize{
  \item \strong{POSTERIOR}: list of MCMC samples representing the posterior distributions of inferred quantities. \code{=NULL} if\code{listOption$doCompress=T}
  \item \strong{QUANT}: list of quantiles from the posterior distributions of inferred quantities
  \item \strong{MEAN}: list of mean of the posterior distributions of inferred quantities
  \item \strong{varEffect}: matrix \code{nEff} x \code{n} of variances related to the main effects
  \item \strong{varResidualEffect}: vector of length \code{n} of variances of residual effects
  \item \strong{listOption}: list of options used to obtained these results (obtained from \code{\link{QUALYPSO.check.option}})
  \item \strong{listScenarioInput}: list of scenario characteristics (obtained from \code{\link{QUALYPSO.process.scenario}})
}
}
\description{
Partition uncertainty in climate responses using an ANOVA inferred with a Bayesian approach.
}
\references{
Evin, G., B. Hingray, J. Blanchet, N. Eckert, S. Morin, and D. Verfaillie.
Partitioning Uncertainty Components of an Incomplete Ensemble of Climate Projections Using Data Augmentation.
Journal of Climate. \url{https://doi.org/10.1175/JCLI-D-18-0606.1}.
}
\author{
Guillaume Evin
}
