\name{plot.midq2q}
\alias{plot.midq2q}

\title{
Plot Quantile Functions
}
\description{
Plot an object generated by \code{\link{midq2q}}.
}
\usage{
\method{plot}{midq2q}(x, ..., xlab = "p", ylab = "Quantile",
	main = "Ordinary Quantile Function", sub = TRUE, verticals = TRUE,
	col.steps = "gray70", cex.points = 1, jumps = FALSE)
}

\arguments{
  \item{x}{
a \code{midq2q} object.
}
  \item{\dots}{
additional arguments for \code{\link{plot.default}}.
}
  \item{xlab}{
a label for the x axis.
}
  \item{ylab}{
a label for the y axis.
}
  \item{main}{
a main title for the plot.
}
  \item{sub}{
if \code{TRUE}, a subtitle with indication of the row of \code{x}.
}
  \item{verticals}{
logical. If \code{TRUE}, draw vertical lines at steps.
}
  \item{col.steps}{
the color for the steps of ordinary quantiles.
}
  \item{cex.points}{
amount by which plotting characters and symbols should be scaled relative to the default. 
}
  \item{jumps}{
logical flag. Should values at jumps be marked?
}


}


\author{
Marco Geraci
}


\seealso{
\code{\link{midq2q}}, \code{\link{midecdf}}, \code{\link{midquantile}}
}

\keyword{print}
