% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/0Int_base_stats.R
\name{outer_allequal}
\alias{outer_allequal}
\title{Test if Two \link[base]{double} Vectors are Element-Wise (Nearly) Equal}
\usage{
outer_allequal(target, current, tolerance = sqrt(.Machine$double.eps), ...)
}
\arguments{
\item{target}{length-\eqn{n} \link[base]{double} \link[base]{vector}, the target value, missing value not allowed}

\item{current}{length-\eqn{n} \link[base]{double} \link[base]{vector}, the value to be compared with \code{target}, missing value not allowed}

\item{tolerance}{positive \link[base]{double} scalar, default \code{sqrt(.Machine$double.eps)}}

\item{...}{potential parameters, currently not in use}
}
\value{
\link{outer_allequal} returns an \eqn{m*n} \link[base]{logical} \link[base]{matrix}
indicating whether the length-\eqn{n} \link[base]{vector} \code{current} is element-wise near-equal to the length-\eqn{m} \link[base]{vector} \code{target}
within the pre specified \code{tolerance}.
}
\description{
Test if two \link[base]{double} vectors are element-wise (nearly) equal.
}
\details{
\link{outer_allequal} is different from \link[base]{all.equal.numeric}, such that
(1). only comparisons between real \link[base]{double} values are performed;
(2). element-wise comparison is performed, with the rows of returned \link[base]{matrix} correspond to \code{current}
and columns correspond to \code{target};
(3). a \link[base]{logical} scalar is always returned for each element-wise comparison.
}
\examples{
x = c(.3, 1-.7, 0, .Machine$double.eps)
outer_allequal(current = x, target = c(.3, 0))

}
\seealso{
\link[base]{all.equal.numeric} \link[base]{outer}
}
