% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fmx.R
\name{fmx}
\alias{fmx}
\title{Create Finite Mixture Distribution}
\usage{
fmx(distname, w = 1, ...)
}
\arguments{
\item{distname}{\link[base]{character} scalar}

\item{w}{(optional) \link[base]{numeric} \link[base]{vector}.
Does not need to sum up to 1; \code{w/sum(w)} will be used internally.}

\item{...}{mixture distribution parameters.
See function \code{\link[=dGH]{dGH()}} for the names and default values of Tukey's \eqn{g}-&-\eqn{h} distribution parameters,
or \link[stats]{dnorm} for the names and default values of normal distribution parameters.}
}
\value{
Function \code{\link[=fmx]{fmx()}} returns an \linkS4class{fmx} object which specifies the parameters of a finite mixture distribution.
}
\description{
..
}
\examples{

(e1 = fmx('norm', mean = c(0,3), sd = c(1,1.3), w = c(1, 1)))
isS4(e1) # TRUE
slotNames(e1)

(e2 = fmx('GH', A = c(0,3), g = c(.2, .3), h = c(.2, .1), w = c(2, 3)))

(e3 = fmx('GH', A = 0, g = .2, h = .2)) # one-component Tukey

}
