% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/corpus.R
\name{characteristic_docs}
\alias{characteristic_docs}
\title{characteristic_docs}
\usage{
characteristic_docs(corpus, dtm, variable, ndocs = 10, nterms = 25,
  p = 0.1)
}
\arguments{
\item{corpus}{A \code{Corpus} object.}

\item{dtm}{A \code{DocumentTermMatrix} object corresponding to \code{corpus}.}

\item{variable}{A vector of values giving the groups for which most frequent
terms should be reported.}

\item{ndocs}{The number of (most characteristic) documents to print.}

\item{nterms}{The number of terms to highlight in documents.}

\item{p}{The maximum p-value up to which specific terms should be hightlighted.}
}
\value{
A list with one \code{Corpus} object for each level (invisibly).
}
\description{
Print documents which are the most characteristic of each level of a variable,
i.e. those with the lowest Chi-squared distance to the average vocabulary
of documents belonging to that level.
}
\details{
Occurrences of the \code{nterms} most specific terms for each level are highlighted.
If stemming or other transformations have been applied to original words
using \code{\link{combine_terms}}, all original words which have been transformed
to the specified terms are highlighted.
}
\examples{

file <- system.file("texts", "reut21578-factiva.xml", package="tm.plugin.factiva")
corpus <- import_corpus(file, "factiva", language="en")
dtm <- build_dtm(corpus)
characteristic_docs(corpus, dtm, meta(corpus)$Date)

# Also works when terms have been combined
dict <- dictionary(dtm)
dtm2 <- combine_terms(dtm, dict)
characteristic_docs(corpus, dtm2, meta(corpus)$Date)

}
