% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{find_param}
\alias{find_param}
\title{Find optimal GIG parameters for W prior}
\usage{
find_param(
  a,
  b,
  n,
  K,
  alpha = rep(1, K),
  nsims = 1000,
  nreps = 5,
  no_cores = 10
)
}
\arguments{
\item{a}{hyper-parameter of prior for R2 ~ Beta(a,b)}

\item{b}{hyper-parameter of prior for R2 ~ Beta(a,b)}

\item{n}{number of observations}

\item{K}{number of response categories}

\item{alpha}{prior hyper-parameters for prior Dirichlet distribution on response probabilities}

\item{nsims}{number of times to simulate data}

\item{nreps}{number of times to run the algorithm (default = 5)}

\item{no_cores}{number of cores to parallelize data-generation process}
}
\value{
Optimal GIG parameters
}
\description{
This function finds the optimal GIG parameters for the prior on W
which induces a beta prior distribution on McFadden's R2.
}
\examples{
\donttest{
a = 1
b = 5
n = 100
K = 3
find_param(a, b, n, K, no_cores=1)
}
}
