% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/R6causal.R
\name{counterfactual}
\alias{counterfactual}
\title{Counterfactual inference via simulation}
\usage{
counterfactual(
  scm,
  situation,
  n,
  target = NULL,
  ifunction = NULL,
  returnscm = FALSE,
  control = list()
)
}
\arguments{
\item{scm}{An SCM object}

\item{situation}{A list or a character string. The list has the following elements:
\itemize{
\item do : NULL or a list containing named elements 'target' and 'ifunction' that
specify the intervention carried out in the situation
\item dolist : NULL or a list of lists containing named elements 'target' and 
'ifunction' that specify the intervention carried out in each parallel world
\item condition : either a string that gives an SQL query ( e.g. "select x,y,z from DATA where" )
or a data.table consisting of the valid rows ( e.g. data.table::data.table( x = 0, y = 0))
}}

\item{n}{Size of the data to be simulated}

\item{target}{NULL or a vector of variable names that specify the target
variable(s) of the counterfactual intervention.}

\item{ifunction}{NULL or a list of functions for the counterfactual intervention.}

\item{returnscm}{A logical, should the internally created twin SCM or parallel 
world SCM returned?}

\item{control}{List of parameters to be passed to the simulation method}
}
\value{
A data table representing the situation after the counterfactual intervention
}
\description{
Counterfactual inference via simulation
}
\examples{
cfdata <- counterfactual(backdoor,
                         situation = list(
                             do = list(target = "x", ifunction = 0),
                             condition = data.table::data.table( x = 0, y = 0)),
                         target = "x",
                         ifunction = 1,
                         n = 1000)
mean(cfdata$y)

backdoor_parallel <- ParallelWorld$new(backdoor,
                                       dolist=list(
                                         list(target = "x", ifunction = 0),
                                         list(target = list("z","x"), ifunction = list(1,0))
                                       )
)
cfdata2 <- counterfactual(backdoor_parallel,
                         situation = list(
                             do = NULL,
                             condition = data.table::data.table( y = 0, y_1 = 0, y_2 = 0)),
                         target = "x",
                         ifunction = 1,
                         n = 1000)
mean(cfdata2$y)
}
