% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genetrait.R
\name{genetrait}
\alias{genetrait}
\title{Generate pseudo phenotypic values}
\usage{
genetrait(
  x,
  sample.sets = NULL,
  candidate = NULL,
  pos = NULL,
  x.par = NULL,
  ZETA = NULL,
  x2 = NULL,
  num.qtn = 3,
  weight = c(2, 1, 1),
  qtn.effect = rep("A", num.qtn),
  prop = 1,
  polygene.weight = 1,
  polygene = TRUE,
  h2 = 0.6,
  h.correction = FALSE,
  seed = NULL,
  plot = TRUE,
  saveAt = NULL,
  subpop = NULL,
  return.all = FALSE,
  seed.env = TRUE
)
}
\arguments{
\item{x}{A n.sample x n.mark genotype matrix where n.sample is sample size and n.mark is the number of markers.}

\item{sample.sets}{A n.sample x n.mark genotype matrix. Markers with fixed effects (QTNs) are chosen from sample.sets.
If sample.sets = NULL, sample.sets = x.}

\item{candidate}{If you want to fix QTN postitions, please set the number where SNPs to be fixed are located in your data (so not position).
If candidate = NULL, QTNs were randomly sampled from sample.sets or x.}

\item{pos}{A n.mark x 1 vector. Cumulative position (over chromosomes) of each marker.}

\item{x.par}{If you don't want to match the sampling population and the genotype data to QTN effects, then use this argument as the latter.}

\item{ZETA}{A list of covariance (relationship) matrix (K: \eqn{m \times m}) and its design matrix (Z: \eqn{n \times m}) of random effects.
Please set names of list "Z" and "K"! You can use more than one kernel matrix.
For example,

ZETA = list(A = list(Z = Z.A, K = K.A), D = list(Z = Z.D, K = K.D))
\describe{
\item{Z.A, Z.D}{Design matrix (\eqn{n \times m}) for the random effects. So, in many cases, you can use the identity matrix.}
\item{K.A, K.D}{Different kernels which express some relationships between lines.}
}
For example, K.A is additive relationship matrix for the covariance between lines, and K.D is dominance relationship matrix.}

\item{x2}{A genotype matrix to calculate additive relationship matrix when Z.ETA = NULL.
If Z.ETA = NULL & x2 = NULL, calcGRM(x) will be calculated as kernel matrix.}

\item{num.qtn}{The number of QTNs}

\item{weight}{The weights for each QTN by their standard deviations. Negative value is also allowed.}

\item{qtn.effect}{Additive of dominance for each marker effect. This argument should be the same length as num.qtn.}

\item{prop}{The proportion of effects of QTNs to polygenetic effects.}

\item{polygene.weight}{If there are multiple kernels, this argument determines the weights of each kernel effect.}

\item{polygene}{If polygene = FALSE, pseudo phenotypes with only QTN effects will be generated.}

\item{h2}{The wide-sense heritability for generating phenotypes. 0 <= h2 < 1}

\item{h.correction}{If TRUE, this function will generate phenotypes to match the genomic heritability and "h2".}

\item{seed}{If seed is not NULL, some fixed phenotypic values will be generated according to set.seed(seed)}

\item{plot}{If TRUE, boxplot for generated phenotypic values will be drawn.}

\item{saveAt}{When drawing any plot, you can save plots in png format. In saveAt, you should substitute the name you want to save.
When saveAt = NULL, the plot is not saved.}

\item{subpop}{If there is subpopulation structure, you can draw boxpots divide by subpopulations.
n.sample x n.subpop matrix. Please indicate the subpopulation information by (0, 1) for each element.
(0 means that line doen't belong to that subpopulation, and 1 means that line belongs to that subpopulation)}

\item{return.all}{If FALSE, only returns generated phenotypic values.
If TRUE, this function will return other information such as positions of candidate QTNs.}

\item{seed.env}{If TRUE, this function will generate different environment effects every time.}
}
\value{
\describe{
\item{trait}{Generated phenotypic values}
\item{u}{Generated genotyope values}
\item{e}{Generated environmental effects}
\item{candidate}{The numbers where QTNs are located in your data (so not position).}
\item{qtn.position}{QTN positions}
\item{heritability}{Genomic heritability for generated phenotypic values.}
}
}
\description{
This function generates pseudo phenotypic values according to the following formula.

\deqn{y = X \beta + Z u + e}

where effects of major genes are regarded as fixed effects \eqn{\beta} and
polygenetic effects are regarded as random effects \eqn{u}.
The variances of \eqn{u} and \eqn{e} are automatically determined by the heritability.
}
