% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fisher.reg.R
\name{fisher.reg}
\alias{fisher.reg}
\title{Fisher Information computation for calculating the confidence intervals in Zero-inflated and Zero-altered regression models}
\usage{
fisher.reg(x, y, b0 = NULL, m, dist = "ZIP", link = "logit")
}
\arguments{
\item{x}{a design matrix containing an intercept column (all ones) along with other available covariates for the response variable}

\item{y}{a zero-inflated or zero-altered(Hurdle) count response variable, represented as an integer vector}

\item{b0}{the initial parameters for the model, calculated as the product of the number of parameters in the specified models and the number of covariates}

\item{m}{M set in trigamma free approach only needed for ZIBNB, BNBH, ZINB, and NBH}

\item{dist}{can be specified as follows: "ZIP" for "zero-inflated Poisson",
"ZINB" for "zero-inflated negative binomial",
"ZINB-r" for "zero-inflated negative binomial with fixed r",
"ZIBNB" for "zero-inflated beta negative binomial",
"ZIBB" for "zero-inflated beta binomial",
"ZIBB-n" for "zero-inflated beta binomial with fixed n",
"ZIBB-ab" for "zero-inflated beta binomial with fixed alpha and beta",
"PH" for "zero-altered(hurdle) Poisson",
"NBH" for "zero-altered(Hurdle) negative binomial",
"NBH-r" for "zero-altered (Hurdle) negative binomial with fixed r",
"BNBH" for " zero-altered (Hurdle) beta negative binomial",
"BBH" for "zero-altered (Hurdle) beta binomial",
"BBH-n" for "zero-altered(Hurdle) beta binomial with fixed n",
and "BBH-ab" for "zero-altered(Hurdle) beta binomial with fixed alpha and beta".}

\item{link}{can be set to one of four different options: "logit" for the logistic link function,
"probit" for the probit link function,
"loglog" for the log-log link function,
and "cloglog" for the complementary log-log link function}
}
\value{
If dist = ZIP, the following values are returned:
\itemize{
\item FisherInformation: Fisher Information matrix for all the parameters and covariates in the model.
\item ConfidenceIntervals: Contains the following information:
\itemize{
\item Lower and upper bounds of the confidence interval.
\item Estimated parameters.
\item Estimation/length ratio.
\item Standard error.
\item Z-score.
}
}
If dist = ZINB, the following values are returned:
\itemize{
\item FisherInformation: Fisher Information matrix for all the parameters and covariates in the model.
\item ConfidenceIntervals: Contains the following information:
\itemize{
\item Lower and upper bounds of the confidence interval.
\item Estimated parameters.
\item Estimation/length ratio.
\item Standard error.
\item Z-score.
}
}
If dist = ZINB-r, the following values are returned:
\itemize{
\item FisherInformation: Fisher Information matrix for all the parameters and covariates in the model.
\item ConfidenceIntervals: Contains the following information:
\itemize{
\item Lower and upper bounds of the confidence interval.
\item Estimated parameters.
\item Estimation/length ratio.
\item Standard error.
\item Z-score.
}
}
If dist = ZIBNB, the following values are returned:
\itemize{
\item FisherInformation: Fisher Information matrix for all the parameters and covariates in the model.
\item ConfidenceIntervals: Contains the following information:
\itemize{
\item Lower and upper bounds of the confidence interval.
\item Estimated parameters.
\item Estimation/length ratio.
\item Standard error.
\item Z-score.
}
}
If dist = ZIBB, the following values are returned:
\itemize{
\item FisherInformation: Fisher Information matrix for all the parameters and covariates in the model.
\item ConfidenceIntervals: Contains the following information:
\itemize{
\item Lower and upper bounds of the confidence interval.
\item Estimated parameters.
\item Estimation/length ratio.
\item Standard error.
\item Z-score.
}
}
If dist = ZIBB-n, the following values are returned:
\itemize{
\item FisherInformation: Fisher Information matrix for all the parameters and covariates in the model.
\item ConfidenceIntervals: Contains the following information:
\itemize{
\item Lower and upper bounds of the confidence interval.
\item Estimated parameters.
\item Estimation/length ratio.
\item Standard error.
\item Z-score.
}
}
If dist = ZIBB-ab, the following values are returned:
\itemize{
\item FisherInformation: Fisher Information matrix for all the parameters and covariates in the model.
\item ConfidenceIntervals: Contains the following information:
\itemize{
\item Lower and upper bounds of the confidence interval.
\item Estimated parameters.
\item Estimation/length ratio.
\item Standard error.
\item Z-score.
}
}
If dist = PH, the following values are returned:
\itemize{
\item FisherInformation: Fisher Information matrix for all the parameters and covariates in the model.
\item ConfidenceIntervals: Contains the following information:
\itemize{
\item Lower and upper bounds of the confidence interval.
\item Estimated parameters.
\item Estimation/length ratio.
\item Standard error.
\item Z-score.
}
}
If dist = NBH, the following values are returned:
\itemize{
\item FisherInformation: Fisher Information matrix for all the parameters and covariates in the model.
\item ConfidenceIntervals: Contains the following information:
\itemize{
\item Lower and upper bounds of the confidence interval.
\item Estimated parameters.
\item Estimation/length ratio.
\item Standard error.
\item Z-score.
}
}
If dist = NBH-r, the following values are returned:
\itemize{
\item FisherInformation: Fisher Information matrix for all the parameters and covariates in the model.
\item ConfidenceIntervals: Contains the following information:
\itemize{
\item Lower and upper bounds of the confidence interval.
\item Estimated parameters.
\item Estimation/length ratio.
\item Standard error.
\item Z-score.
}
}
If dist = BNBH, the following values are returned:
\itemize{
\item FisherInformation: Fisher Information matrix for all the parameters and covariates in the model.
\item ConfidenceIntervals: Contains the following information:
\itemize{
\item Lower and upper bounds of the confidence interval.
\item Estimated parameters.
\item Estimation/length ratio.
\item Standard error.
\item Z-score.
}
}
If dist = BBH, the following values are returned:
\itemize{
\item FisherInformation: Fisher Information matrix for all the parameters and covariates in the model.
\item ConfidenceIntervals: Contains the following information:
\itemize{
\item Lower and upper bounds of the confidence interval.
\item Estimated parameters.
\item Estimation/length ratio.
\item Standard error.
\item Z-score.
}
}
If dist = BBH-n, the following values are returned:
\itemize{
\item FisherInformation: Fisher Information matrix for all the parameters and covariates in the model.
\item ConfidenceIntervals: Contains the following information:
\itemize{
\item Lower and upper bounds of the confidence interval.
\item Estimated parameters.
\item Estimation/length ratio.
\item Standard error.
\item Z-score.
}
}
If dist = BBH-ab, the following values are returned:
\itemize{
\item FisherInformation: Fisher Information matrix for all the parameters and covariates in the model.
\item ConfidenceIntervals: Contains the following information:
\itemize{
\item Lower and upper bounds of the confidence interval.
\item Estimated parameters.
\item Estimation/length ratio.
\item Standard error.
\item Z-score.
}
}
}
\description{
Fisher Information computation for calculating the confidence intervals in Zero-inflated and Zero-altered regression models
}
\examples{
intercept<- rep(1,4406)
dt = DebTrivedi[, c(6:8, 13, 15, 18)]
dt = cbind(intercept, dt)
dt$gender.male <- ifelse(dt$gender == 'male', 1, 0)
dt$gender.female <- ifelse(dt$gender == 'female', 1, 0)
dt$health.poor <- ifelse(dt$health == 'poor', 1, 0)
dt$health.average <- ifelse(dt$health == 'average', 1, 0)
dt$health.excellent <- ifelse(dt$health == 'excellent', 1, 0)
dt$privins.yes <- ifelse(dt$privins == 'yes', 1, 0)
dt$privins.no <- ifelse(dt$privins == 'no', 1, 0)
y = DebTrivedi[,1]
x = data.matrix(dt[, c(1, 2, 4, 6, 8, 10, 12, 13)])
np = dim(x)[2]
b0 = c (0.1,0.10,0.1,0.1,0.1,0.1,0.1,0.1,
0.2,0.20,0.20,0.20,0.20,0.20,0.20,0.20)
fisher.reg(x, y, b0=b0, m=1e3, dist="ZIP", link="probit")
}
