% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Connection.R
\docType{methods}
\name{dbShow}
\alias{dbShow}
\alias{dbShow,AthenaConnection-method}
\title{Show Athena table's DDL}
\usage{
dbShow(conn, name, ...)

\S4method{dbShow}{AthenaConnection}(conn, name, ...)
}
\arguments{
\item{conn}{A \linkS4class{DBIConnection} object, as returned by
\code{\link[=dbConnect]{dbConnect()}}.}

\item{name}{A character string specifying a DBMS table name.}

\item{...}{Other parameters passed on to methods.}
}
\value{
\code{dbShow()} returns \code{\link[DBI]{SQL}} characters of the Athena table DDL.
}
\description{
Executes a statement to return the data description language (DDL) of the Athena table.
}
\examples{
\dontrun{
# Note: 
# - Require AWS Account to run below example.
# - Different connection methods can be used please see `RAthena::dbConnect` documnentation

library(DBI)

# Demo connection to Athena using profile name 
con <- dbConnect(RAthena::athena())
                 
# write iris table to Athena                  
dbWriteTable(con, "iris",
             iris,
             partition = c("timestamp" = format(Sys.Date(), "\%Y\%m\%d")),
             s3.location = "s3://path/to/store/athena/table/")

# return table ddl
RAthena::dbShow(con, "iris")

# disconnect from Athena
dbDisconnect(con)
}
}
