% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GK.control.R
\name{GK.control}
\alias{GK.control}
\title{Control parameters for Gautier-Kitamura bivariate random coefficient binary response}
\usage{
GK.control(n, u = -20:20/10, v = -20:20/10, T = 3, TX = 10, Mn = 1/log(n)^2)
}
\arguments{
\item{n}{the sample size}

\item{u}{grid values for intercept coordinate}

\item{v}{grid values for slope coordinate}

\item{T}{Truncation parameter for numerator must grow "sufficiently slowly with n"}

\item{TX}{Truncation parameter for denomerator must grow "sufficiently slowly with n"}

\item{Mn}{Trimming parameter "chosen to go to 0 slowly with n"}
}
\value{
updated list
}
\description{
These parameters can be passed via the \code{...} argument of the \code{rcbr} function.
defaults as suggested in Gautier and Kitamura matlab code
}
