% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/polycount.R
\name{polycount}
\alias{polycount}
\title{Check Cell Count  for degenerate hyperplane arrangements}
\usage{
polycount(A, b, maxints = 10)
}
\arguments{
\item{A}{is a n by m matrix of hyperplane slope coefficients}

\item{b}{is an n vector of hyperplane intercept coefficients}

\item{maxints}{is maximum number of lines allowed to cross at the same vertex}
}
\value{
number of distinct cells
}
\description{
When the hyperplane arrangement is degenerate, i.e. not in general position,
the number of distinct cells can be checked against the formula of
Alexanderson and Wetzel (1981).
}
\references{
Alexanderson, G.L and J.E. Wetzel, (1981) Arrangements of planes in space, 
Discrete Math, 34, 219--240.
}
