% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genesets.R
\name{getGeneSets}
\alias{getGeneSets}
\title{Get gene sets}
\usage{
getGeneSets(
  database = c("KEGG", "GO"),
  org = "hsa",
  taxid = 9606,
  namespace = c("biological_process", "molecular_function", "cellular_component"),
  minSize = 10,
  maxSize = 1000
)
}
\arguments{
\item{database}{The database of the gene sets. E.g, KEGG, GO.}

\item{org}{The organism abbreviation. E.g, hsa, mmu, dme, etc.
To see the full list of supported organisms, visit https://www.genome.jp/kegg/catalog/org_list.html.
This parameter is only used when database is KEGG.}

\item{taxid}{The NCBI taxonomy ID of the organism.
This parameter is only used when database is GO.}

\item{namespace}{The namespace of the GO terms. E.g, biological_process, molecular_function, cellular_component.}

\item{minSize}{The minimum size of the gene sets.}

\item{maxSize}{The maximum size of the gene sets.
This parameter is only used when database is GO.}
}
\value{
A named list with three elements: database, genesets and names.
}
\description{
This function retrieves gene sets for a given organism.
}
\examples{
\donttest{

library(RCPA)

getGeneSets("KEGG", org = "hsa", minSize = 10, maxSize = 1000)
getGeneSets("GO", taxid = 9606, namespace = "biological_process", minSize = 10, maxSize = 1000)

}
}
