% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logregC.r
\name{logregC}
\alias{logregC}
\title{Logistic regression analysis with options for weighted observations, odds ratio reports, model fit statistics, and plots of residuals}
\usage{
logregC(formula, w, data, digits = 3, orci = FALSE, fit.stats = FALSE,
  anova = FALSE, pre = FALSE, printC = FALSE, res.plots = FALSE, ...)
}
\arguments{
\item{formula}{should be in dataset$dv ~ datatset$iv1 + dataset$iv2 unless dataset specified in optional data argument.}

\item{w}{(Optional) Sampling weights of variable, must be numeric; should be in dataset$weightvar form unless dataset specified in optional data argument.}

\item{data}{(Optional) Name of dataset that contains dv, iv (and w) variables.}

\item{digits}{(Optional) Number of decimal places reported in result (defaults to 2).}

\item{orci}{(Optional) Do you want table reporting odds ratios for coefficients with confidence intervals? (default: FALSE)}

\item{fit.stats}{(Optional) Do you want a table of assorted model fit statistics? (default: FALSE)}

\item{anova}{(Optional) Do you want ANOVA table reported? (default: FALSE)}

\item{pre}{(Optional) Do you want table reporting proportion reduction in error achieved by model? This is a Lambda-style measure of model fit. (default: FALSE)}

\item{printC}{(Optional) Do you want results printed to .html file in your working directory? Default is FALSE. Set to TRUE to print results.}

\item{res.plots}{(Optional) Do you want a set of diagnostic plots of model residuals? (default: FALSE)}

\item{...}{(Optional) Additional arguments passed to \code{\link[stats]{glm}} function (unweighted models) or \code{\link[survey]{svyglm}} function (weighted models).}
}
\value{
Returns a glm (unweighted models) or svyglm (weighted models) object.
}
\description{
Logistic regression analysis function with many useful features. Its standard output included a table of coefficients, table of deviance residuals, and summary of additional model information. Options include weighting observations, additional reports on odds ratios, ANOVA, multiple measures of model fit, proportional reduction in error, and diagnostic plots of residuals.
}
\section{Textbook References}{

\itemize{
\item Philip H. Pollock and Barry C. Edwards, \emph{An R Companion to Political Analysis, 3rd Edition} (Thousand Oaks, CA: Sage Publications, Forthcoming 2022), Chapter 14.
\item Philip H. Pollock and Barry C. Edwards, \emph{The Essentials of Political Analysis, 6th Edition} (Thousand Oaks, CA: Sage Publications, 2020), Chapter 9. ISBN-13: 978-1506379616; ISBN-10: 150637961.
}
}

\section{Online Resources}{

\itemize{
\item \href{https://www.poliscidata.com/pages/rDemosResources.php?chapter=14}{R Tutorials & Resources for Logistic Regression}, compiled by Barry C. Edwards
\item \href{https://edge.sagepub.com/pollock}{Sage Edge Resources for Political Analysis Series}, for streaming videos, flashcards, and more student resources for textbooks by Pollock and Edwards, from Sage Publications.
\item \href{https://www.poliscidata.com}{Political Science Data Web Site}: Find datasets for your own research and resources to help with the analysis.
}
}

\examples{
  library(RCPA3)
  
  \donttest{
  # basic usage with variable vectors
  logregC(states$battleground2020 ~ states$vep16.turnout)
  
  # with post-estimation analysis
  logregC(states$battleground2020 ~ states$vep16.turnout, orci=TRUE, fit.stats=TRUE, 
          anova=TRUE, pre=TRUE, res.plots=TRUE)
  }
}
