% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/03_IFE_algorithm_functions.R
\name{get_final_estimation}
\alias{get_final_estimation}
\title{Function that returns the final clustering, based on the estimated number of groups and common and group specific factors.}
\usage{
get_final_estimation(df, opt_groups, k, kg, type, limit_est_groups = 20)
}
\arguments{
\item{df}{input dataframe (this will be df_results_full)}

\item{opt_groups}{the optimal number of groups}

\item{k}{the optimal number of common factors}

\item{kg}{vector with the optimal number of group specific factors}

\item{type}{defines which estimation to return: options are "clustering", "beta", "fg" (group specific factors), "lg" (loadings corresponding to fg), "f" (common factors), "l" (loadings corresponding to f),}

\item{limit_est_groups}{maximum allowed number of groups that can be estimated}
}
\value{
This function returns the estimations of the chosen configuration.
If type is "clustering" it returns a numeric vector with the estimated group membership for all time series.
If type is "beta", "lg" the function returns a data.frame.
If type is "f" or "l" the function also returns a data.frame. If no common factors were estimated in the optimized configuration, then NA is returned.
If type is "fg" the function returns a list.
}
\description{
Function that returns the final clustering, based on the estimated number of groups and common and group specific factors.
}
\examples{
get_final_estimation(df_results_example, 3, 0, c(3, 3, 3), "clustering")
get_final_estimation(df_results_example, 3, 0, c(3, 3, 3), "beta")
get_final_estimation(df_results_example, 3, 0, c(3, 3, 3), "fg")
get_final_estimation(df_results_example, 3, 0, c(3, 3, 3), "lg")
}
