% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/Pmix.R
\name{Pmix}
\alias{Pmix}
\title{Poisson mixture estimation via Kiefer Wolfowitz MLE}
\usage{
Pmix(x, v = 300, ...)
}
\arguments{
\item{x}{Data: Sample observations (integer valued)}

\item{v}{Grid Values for the mixing distribution defaults to equal
spacing of length v when v is specified as a scalar}

\item{...}{other parameters passed to KWDual to control optimization}
}
\value{
An object of class density with components:
	\item{x}{points of evaluation of the mixing density}
	\item{y}{function values of the mixing density at x}
	\item{g}{function values of the mixture density on \eqn{0, 1, ... max(x)+1}}
	\item{logLik}{Log Likelihood value at the estimate}
	\item{dy}{Bayes rule estimate of Poisson rate parameter at each x}
	\item{status}{exit code from the optimizer}
}
\description{
Poisson mixture estimation via Kiefer Wolfowitz MLE
}
\details{
Kiefer Wolfowitz NPMLE estimation for Poisson mixtures.
}
\author{
Roger Koenker
}
\references{
Kiefer, J. and J. Wolfowitz Consistency of the Maximum
Likelihood Estimator in the Presence of Infinitely Many Incidental
Parameters \emph{Ann. Math. Statist}. Volume 27, Number 4 (1956), 887-906.
}
\keyword{nonparametric}

