#' @name flies
#' @title Medfly Data
#' @description Medfly data from the Carey et al (1992) experiment.  
#' There are 1,203,646 uncensored survival times!
#' @usage flies
#' @format A data frame with 19072 observations on the following 17 variables.
#' \itemize{
#'     \item{\code{age}}{age at death in days}
#'     \item{\code{num}}{frequency count of age at death}
#'     \item{\code{prcurr}}{current proportion male}
#'     \item{\code{current}}{current density}
#'     \item{\code{cohort}}{cohort/pupal batch}
#'     \item{\code{size}}{pupal size}
#'     \item{\code{cage}}{cage number}
#'     \item{\code{female}}{female = 1}
#'     \item{\code{cumul}}{cumulative density}
#'     \item{\code{prcumu}}{cumulative proportion male}
#'     \item{\code{begin}}{initial cage density}
#'     \item{\code{prbegin}}{initial proportion mail}
#'     \item{\code{size4}}{size group 4}
#'     \item{\code{size5}}{size group 5}
#'     \item{\code{size6}}{size group 6}
#'     \item{\code{size7}}{size group 7}
#'     \item{\code{size8}}{size group 8}
#' }
#' @details Quoting from Carey et al (1992) ``...Pupae
#' were sorted into one of five size classes using a pupal sorter.  This
#' enabled size dimorphism to be eliminated as a potential source of sex-specific
#' mortality differences.  Approximately, 7,200 medflies (both sexes) of a given
#' size class were maintained in each of 167 mesh covered, 15 cm by 60 cm
#' by 90 cm aluminum cages.  Adults were given a diet of sugar and water,
#' ad libitum,  and each day dead flies were removed, counted and their sex
#' determined ...''
#' @references Carey, J.R., Liedo, P.,  Orozco, D.  and  Vaupel, J.W.  (1992)
#' Slowing of mortality rates at older ages in large Medfly cohorts,
#' \emph{Science,} 258, 457-61.
#' 
#' Koenker, R. and O. Geling (2001)  Reappraising Medfly Longevity:
#' A Quantile Regression Survival Analysis, \emph{J. Am. Stat. Assoc},
#' 96, 458-468.
#' 
#' Koenker, R. and  Jiaying Gu, (2013) ``Frailty, Profile Likelihood and Medfly 
#' Mortality,'' \emph{ Contemporary Developments in Statistical Theory: 
#' A Festschrift for Hira Lal Koul}, S.N. Lahiri,  A. Schick,  Ashis Sengupta, 
#' and T.N. Sriram, (eds.), Springer.

#' @keywords datasets
NULL
