% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BDGLmix.R
\name{BDGLmix}
\alias{BDGLmix}
\title{Efron Bayesian Deconvolution Estimator for Gaussian Mixtures}
\usage{
BDGLmix(y, T = 300, sigma = 1, df = 5, c0 = 0.1)
}
\arguments{
\item{y}{Data: Sample Observations}

\item{T}{Undata: Grid Values defaults equal spacing of with T bins, when T is
a scalar}

\item{sigma}{scale parameter of the Gaussian noise, may take vector value of 
length(y)}

\item{df}{degrees of freedom of the natural spline basis}

\item{c0}{penalty parameter for the Euclidean norm penalty.}
}
\value{
An object of class {GLmix, density} with components: 
     \item{x}{points of  evaluation on the domain of the density} 
     \item{y}{estimated function values at these points of the mixing density} 
     \item{sigma}{returns a sigma = 1 for compatibility with GLmix}
}
\description{
Efron (2016, 2019) penalized logspline density estimator for Gaussian
mixture model g-modeling.  Returns an object of class GLmix to facilitate
prediction compatible with Kiefer-Wolfowitz GLmix  estimation.  In particular
percentile confidence intervals can be constructed based on posterior quantiles.
Assumes homoscedastic standard Gaussian noise, for the moment.
}
\references{
Efron, B. (2016) Empirical Bayes deconvolution estimates,
Biometrika, 103, 1–20, 
Efron, B. (2019) Bayes, Oracle Bayes and Empirical Bayes,  
Statistical Science, 34, 177-201.
}
\author{
Adapted from a similar implementation in the R package deconvolveR of
Narasimhan and Efron.
}
\keyword{nonparametric}
