% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checks.R
\name{check_data_arg_exists}
\alias{check_data_arg_exists}
\title{Check requested data arg exists in REDCap data}
\usage{
check_data_arg_exists(db_data, col, arg, call = caller_env())
}
\arguments{
\item{db_data}{The REDCap database output generated by
\code{REDCapR::redcap_read_oneshot()$data}}

\item{col}{The column to check for in \code{redcap_data}}

\item{arg}{The argument used for the column check}

\item{call}{The calling environment to use in the error message}
}
\value{
An error message saying the requested data does not exist
}
\description{
Provide an error message when an argument is requested, but is not found in
any \code{read_redcap()} \code{redcap_data} output.
}
\details{
Currently used for the following arguments:
\itemize{
\item{\code{export_survey_fields}: \verb{*_timestamp}}
\item{\code{export_data_access_groups}: \code{redcap_data_access_group}}
}
}
\keyword{internal}
