% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions.R
\name{PlotFunction}
\alias{PlotFunction}
\title{"PlotFunction"}
\usage{
PlotFunction(GeneID = NULL, ExonID = NULL, Data, REIDS_Output,
  GeneLevelData = NULL, ExonLevelData = NULL, FIRMA_Data = NULL, groups,
  ylabel = NULL, title = "")
}
\arguments{
\item{GeneID}{The gene ID of the gene of interest.}

\item{ExonID}{The exon ID of the exon of interest.}

\item{Data}{The processed data as returned by DataProcessing. This is were the observed probe intensities will be retrieved.}

\item{REIDS_Output}{The output of the REIDS model. This is were the array scores will be retrieved.}

\item{GeneLevelData}{The gene level summarized data to retrieve the gene level values.}

\item{ExonLevelData}{The exon level summarized data to retrieve the exon level values.}

\item{FIRMA_Data}{The output of the FIRMA model to retrieve the FIRMA scores of the samples.}

\item{groups}{The groups of interest in the data.}

\item{ylabel}{The label for the y-axis.}

\item{title}{A title for the plot.}
}
\description{
The PlotFunction produces three plots concerning a specific exon and its corresponding gene.
}
\examples{
\dontrun{
PlotFunction(GeneID="TC0100207",ExonID="PSR010002121",Data=HTAData_RASA,GDS_Output=
HTAData_RASA_OutputGDSModel,GeneLevelData=HTA_GeneLevelSummarized_rma_RASA,ExonLevelData=
HTA_ExonLevelSummarized_rma_RASA,FIRMA_Data=NULL,groups=list(group1=c(1,2,3),group2=c(4,5,6)),
ylabel="",plottype="sweave",location=NULL,title="PSR010002121")
}
}
