% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_s3_rendocopulacorrection.R
\name{predict.rendo.copula.correction}
\alias{predict.rendo.copula.correction}
\title{Predict method for Models using the Gaussian Copula Approach}
\usage{
\method{predict}{rendo.copula.correction}(object, newdata, ...)
}
\arguments{
\item{object}{Object of class inheriting from "rendo.copula.correction"}

\item{newdata}{An optional data frame in which to look for variables with which to predict.
If omitted, the fitted values are returned.}

\item{...}{ignored, for consistency with the generic function.}
}
\value{
\code{predict.copula.correction} produces a vector of predictions
}
\description{
Predicted values based on linear models with endogenous regressors estimated using
the gaussian copula.
}
\examples{
\donttest{
\dontrun{
data("dataCopCont")

c1 <- copulaCorrection(y~X1+X2+P|continuous(P), num.boots=10,
                       data=dataCopCont)

# returns the fitted values
predict(c1)

# using the data used for fitting also for predicting,
# correctly results in fitted values
all.equal(predict(c1, dataCopCont), fitted(c1)) # TRUE
}}

}
\seealso{
The model fitting function \code{\link[REndo:copulaCorrection]{copulaCorrection}}
}
