/*
 * Decompiled with CFR 0.152.
 */
package freak.module.fitness.bitstring;

import freak.core.control.Schedule;
import freak.core.fitness.AbstractStaticSingleObjectiveFitnessFunction;
import freak.core.population.Genotype;
import freak.module.searchspace.BitString;
import freak.module.searchspace.BitStringGenotype;
import java.util.BitSet;

public class RRR1ptXover
extends AbstractStaticSingleObjectiveFitnessFunction {
    public RRR1ptXover(Schedule schedule) {
        super(schedule);
    }

    protected double evaluate(Genotype genotype) {
        BitSet bs = ((BitStringGenotype)genotype).getBitSet();
        int dimension = ((BitString)this.getSchedule().getPhenotypeSearchSpace()).getDimension();
        int cardinality = bs.cardinality();
        if (cardinality == dimension) {
            return 2 * dimension * dimension;
        }
        int m = dimension / 3;
        if (cardinality > dimension - m) {
            return 0.0;
        }
        int longest = 0;
        int count = 0;
        int i = 0;
        while (i < dimension) {
            if (bs.get(i)) {
                ++count;
            } else {
                if (count > longest) {
                    longest = count;
                }
                count = 0;
            }
            ++i;
        }
        if (count > longest) {
            longest = count;
        }
        return dimension * cardinality + longest;
    }

    public String getName() {
        return "Real Royal Road for 1pt Crossover";
    }

    public String getDescription() {
        return "This Real Royal Road function was designed in order to demonstrate that crossover can be essential.\nThe fitness of a search point x in {0,1}^n is defined as follows:\nRRR(x) = 2n^2 if x = 1^n\nRRR(x) = n*OneMax(x)+b(x) if OneMax(x) <= 2n/3\nRRR(x) = 0 otherwise\nOneMax(x) denotes the number of ones in x.\nb(x) denotes the length of the longest block consisting of ones only.\n\nThis is the first function for which could be proven that a genetic algorithm with crossover can optimize it in expected polynomial time while all evolution strategies based only on mutation and selection need expected exponential time.\n\nFor further details see \"Real Royal Road Functions - Functions Where Crossover Provably is Essential\" by Ingo Wegener.";
    }

    public double getOptimalFitnessValue() throws UnsupportedOperationException {
        int n = ((BitString)this.getSchedule().getPhenotypeSearchSpace()).getDimension();
        return 2 * n * n;
    }

    public double getLowerBound() throws UnsupportedOperationException {
        return 0.0;
    }

    public double getUpperBound() throws UnsupportedOperationException {
        return this.getOptimalFitnessValue();
    }

    public Genotype getPhenotypeOptimum() throws UnsupportedOperationException {
        int dimension = ((BitString)this.getSchedule().getPhenotypeSearchSpace()).getDimension();
        BitSet bs = new BitSet(dimension);
        bs.set(0, dimension);
        return new BitStringGenotype(bs, dimension);
    }
}

