/*
 * Decompiled with CFR 0.152.
 */
package freak.module.observer;

import freak.core.control.Schedule;
import freak.core.event.IndividualListEvent;
import freak.core.event.IndividualListEventListener;
import freak.core.fitness.SingleObjectiveFitnessFunction;
import freak.core.modulesupport.Configurable;
import freak.core.modulesupport.UnsupportedEnvironmentException;
import freak.core.observer.AbstractObserver;
import freak.core.population.Individual;
import freak.core.population.IndividualList;

public class FitnessVariance
extends AbstractObserver
implements IndividualListEventListener,
Configurable {
    public FitnessVariance(Schedule schedule) {
        super(schedule);
        this.setMeasure(1);
    }

    public void testSchedule(Schedule schedule) throws UnsupportedEnvironmentException {
        super.testSchedule(schedule);
        if (!(schedule.getFitnessFunction() instanceof SingleObjectiveFitnessFunction)) {
            throw new UnsupportedEnvironmentException("This module works on single objective fitness functions only.");
        }
    }

    public String getName() {
        return "Fitness Variance";
    }

    public String getDescription() {
        return "Computes the current population's fitness variance.";
    }

    public Class getOutputDataType() {
        return double[].class;
    }

    public void individualList(IndividualListEvent evt) {
        IndividualList individualList = evt.getIndividualList();
        Individual[] indList = individualList.toArray();
        double[] values = new double[indList.length];
        double sum = 0.0;
        int i = 0;
        while (i < indList.length) {
            values[i] = ((SingleObjectiveFitnessFunction)this.getSchedule().getFitnessFunction()).evaluate(indList[i], individualList);
            sum += values[i];
            ++i;
        }
        double average = sum / (double)values.length;
        sum = 0.0;
        int i2 = 0;
        while (i2 < indList.length) {
            sum += (values[i2] - average) * (values[i2] - average);
            ++i2;
        }
        average = sum / (double)values.length;
        this.updateViews(new Double(average));
    }

    public void createEvents() {
        super.createEvents();
        this.getSchedule().getEventController().addEvent(this, "Get individuals from", IndividualListEvent.class, this.getSchedule().getPopulationManager());
    }
}

