/*
 * Decompiled with CFR 0.152.
 */
package freak.module.fitness.pointset.math;

import freak.module.fitness.pointset.math.matrix.Matrix;
import freak.module.fitness.pointset.math.matrix.Vector;
import freak.module.fitness.pointset.math.matrix.view.NormalView;
import freak.module.fitness.pointset.math.matrix.view.VectorView;

public abstract class EquationSolver {
    protected Matrix A;
    protected Vector B;
    protected Vector result;
    int dimension;
    protected boolean canBeChanged;
    protected boolean upToDate;

    public EquationSolver(int dimension) {
        this.dimension = dimension;
        this.A = new Matrix(dimension, dimension);
        this.B = new Vector(dimension);
    }

    public EquationSolver(Matrix A, Vector B) throws Exception {
        if (!A.isSquared()) {
            throw new Exception("Nicht unterstuetzter Typ");
        }
        this.A = A;
        this.B = B;
    }

    public void alloweChanging() {
        this.canBeChanged = true;
    }

    public void forbitChanging() {
        this.canBeChanged = false;
    }

    public Vector solve() throws Exception {
        if (!this.upToDate) {
            if (this.canBeChanged || !this.willSolveChangeTheMatrix()) {
                this.solve(new NormalView(this.A), new VectorView(this.B));
            } else {
                NormalView nvA = new NormalView(this.A);
                NormalView nvB = new NormalView(this.B);
                nvA.setMatrix(nvA.copyModelFromView());
                nvB.setMatrix(nvB.copyModelFromView());
                this.solve(nvA, new VectorView(nvB));
            }
            this.upToDate = true;
        }
        return this.result;
    }

    protected abstract boolean willSolveChangeTheMatrix();

    abstract void solve(NormalView var1, VectorView var2) throws Exception;
}

