/*
 * Decompiled with CFR 0.152.
 */
package freak.module.operator.split.booleanfunction;

import freak.core.graph.HasFloatingNumberOfOutPorts;
import freak.core.graph.OperatorGraph;
import freak.core.graph.Split;
import freak.core.population.Individual;
import freak.core.population.IndividualList;
import freak.core.population.Population;
import freak.module.searchspace.BooleanFunctionGenotype;
import java.util.Iterator;

public class PopulationSplit
extends Split
implements HasFloatingNumberOfOutPorts {
    public PopulationSplit(OperatorGraph graph) {
        super(graph);
    }

    public IndividualList[] process(IndividualList[] origin) {
        int noOfListsToGenerate = this.getNumberOfOutPorts();
        if (noOfListsToGenerate == 0) {
            return new IndividualList[0];
        }
        if (noOfListsToGenerate == 1) {
            return origin;
        }
        Iterator iterator = origin[0].iterator();
        IndividualList[] result = new IndividualList[noOfListsToGenerate];
        int i = 0;
        while (i < noOfListsToGenerate) {
            result[i] = new Population(this.graph.getSchedule());
            ++i;
        }
        Individual ind = null;
        while (iterator.hasNext()) {
            ind = (Individual)iterator.next();
            BooleanFunctionGenotype bfg = (BooleanFunctionGenotype)ind.getGenotype();
            int list = bfg.getPopulation();
            if (list >= noOfListsToGenerate) {
                list = noOfListsToGenerate - 1;
            }
            result[list].addIndividual(ind);
        }
        return result;
    }

    public String getName() {
        return "PopulationSplit";
    }

    public String getDescription() {
        return "Splits the individual list into lists according to their population.The first outport gets a list of all individuals from population 0,the second all from population 1 and so on.The last output additionally contains all individuals from populations that have a number>= the number of outputs.";
    }
}

