/*
 * Decompiled with CFR 0.152.
 */
package freak.module.searchspace;

import freak.core.modulesupport.inspector.StringArrayWrapper;
import freak.module.searchspace.GraphEdgeSelection;
import freak.module.searchspace.GraphEdgeSelectionConfigurationPanelUI;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;

public class GraphEdgeSelectionConfigurationPanel
extends GraphEdgeSelectionConfigurationPanelUI {
    private GraphEdgeSelection searchSpace;

    GraphEdgeSelectionConfigurationPanel(GraphEdgeSelection searchSpace) {
        super(searchSpace);
        this.searchSpace = searchSpace;
        this.addListeners();
        this.readAll();
        this.updateEnables();
    }

    private void addListeners() {
        this.typeBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GraphEdgeSelectionConfigurationPanel.this.writeType();
                GraphEdgeSelectionConfigurationPanel.this.updateEnables();
            }
        });
        this.verticesField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GraphEdgeSelectionConfigurationPanel.this.writeVertices();
            }
        });
        this.edgesField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GraphEdgeSelectionConfigurationPanel.this.writeEdges();
            }
        });
        this.probabilityField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GraphEdgeSelectionConfigurationPanel.this.writeProb();
            }
        });
        this.weightField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GraphEdgeSelectionConfigurationPanel.this.writeWeight();
            }
        });
        this.trianglesField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GraphEdgeSelectionConfigurationPanel.this.writeTriangles();
            }
        });
        this.rngBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GraphEdgeSelectionConfigurationPanel.this.writeRNG();
                GraphEdgeSelectionConfigurationPanel.this.updateEnables();
            }
        });
        this.seedField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GraphEdgeSelectionConfigurationPanel.this.writeSeed();
            }
        });
        this.verticesLolliField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GraphEdgeSelectionConfigurationPanel.this.writeVertLolli();
            }
        });
        this.degreeKField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GraphEdgeSelectionConfigurationPanel.this.writeDegreeK();
            }
        });
        this.verticesField.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                GraphEdgeSelectionConfigurationPanel.this.writeVertices();
            }
        });
        this.edgesField.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                GraphEdgeSelectionConfigurationPanel.this.writeEdges();
            }
        });
        this.probabilityField.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                GraphEdgeSelectionConfigurationPanel.this.writeProb();
            }
        });
        this.weightField.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                GraphEdgeSelectionConfigurationPanel.this.writeWeight();
            }
        });
        this.trianglesField.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                GraphEdgeSelectionConfigurationPanel.this.writeTriangles();
            }
        });
        this.keepBox.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                GraphEdgeSelectionConfigurationPanel.this.writeKeep();
            }
        });
        this.rngBox.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                GraphEdgeSelectionConfigurationPanel.this.writeRNG();
            }
        });
        this.seedField.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                GraphEdgeSelectionConfigurationPanel.this.writeSeed();
            }
        });
        this.verticesLolliField.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                GraphEdgeSelectionConfigurationPanel.this.writeVertLolli();
            }
        });
        this.degreeKField.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                GraphEdgeSelectionConfigurationPanel.this.writeDegreeK();
            }
        });
    }

    private void readAll() {
        this.typeBox.setSelectedIndex(this.searchSpace.getPropertyInitializationType().getIndex());
        this.verticesField.setText(this.searchSpace.getPropertyNumberOfVertices().toString());
        this.edgesField.setText(this.searchSpace.getPropertyNumberOfEdges().toString());
        this.probabilityField.setText(this.searchSpace.getPropertyProbabilityForEdge().toString());
        this.weightField.setText(this.searchSpace.getPropertyMaximalWeight().toString());
        this.keepBox.setSelected(this.searchSpace.getPropertyKeepGraphDuringBatch());
        this.rngBox.setSelected(this.searchSpace.getPropertyUseInternalRNG());
        this.seedField.setText(this.searchSpace.getPropertyInternalRNGSeed().toString());
        int triangles = (this.searchSpace.getPropertyVerticesInTriangles() - 1) / 2;
        this.trianglesField.setText(String.valueOf(triangles));
    }

    private void writeType() {
        this.searchSpace.setPropertyInitializationType(new StringArrayWrapper(this.searchSpace.initTypes, this.typeBox.getSelectedIndex()));
    }

    private void writeSeed() {
        this.searchSpace.setPropertyInternalRNGSeed(new Integer(this.seedField.getText()));
    }

    private void writeKeep() {
        this.searchSpace.setPropertyKeepGraphDuringBatch(new Boolean(this.keepBox.isSelected()));
    }

    private void writeRNG() {
        this.searchSpace.setPropertyUseInternalRNG(new Boolean(this.rngBox.isSelected()));
    }

    private void writeTriangles() {
        int triangles = Integer.parseInt(this.trianglesField.getText()) * 2 + 1;
        this.searchSpace.setPropertyVerticesInTriangles(new Integer(triangles));
    }

    private void writeWeight() {
        this.searchSpace.setPropertyMaximalWeight(new Integer(this.weightField.getText()));
    }

    private void writeProb() {
        this.searchSpace.setPropertyProbabilityForEdge(new Double(this.probabilityField.getText()));
    }

    private void writeEdges() {
        this.searchSpace.setPropertyNumberOfEdges(new Integer(this.edgesField.getText()));
    }

    private void writeVertices() {
        this.searchSpace.setPropertyNumberOfVertices(new Integer(this.verticesField.getText()));
    }

    private void writeVertLolli() {
        this.searchSpace.setPropertyVerticesLolli(new Integer(this.verticesLolliField.getText()));
    }

    private void writeDegreeK() {
        this.searchSpace.setPropertyDegreeK(new Integer(this.degreeKField.getText()));
    }

    private void updateEnables() {
        switch (this.typeBox.getSelectedIndex()) {
            case 0: {
                this.fixedEdgeNumber();
                break;
            }
            case 1: {
                this.fixedEdgeProb();
                break;
            }
            case 2: {
                this.fixedEdgeBinVal();
                break;
            }
            case 3: {
                this.fullGraph();
                break;
            }
            case 4: {
                this.ingosGraph();
                break;
            }
            case 5: {
                this.fullGraph();
                break;
            }
            case 6: {
                this.path();
                break;
            }
            case 7: {
                this.randomTree();
                break;
            }
            case 8: {
                this.lollipop();
                break;
            }
            case 9: {
                this.k_tree();
                break;
            }
            case 10: {
                this.semi();
                break;
            }
            case 11: {
                this.semiP();
                break;
            }
            case 12: {
                this.trapLine();
            }
        }
    }

    private void fixedEdgeNumber() {
        this.edgesLabel.setEnabled(true);
        this.edgesField.setEnabled(true);
        this.probabilityLabel.setEnabled(false);
        this.probabilityField.setEnabled(false);
        this.weightLabel.setEnabled(true);
        this.weightField.setEnabled(true);
        this.trianglesLabel.setEnabled(false);
        this.trianglesField.setEnabled(false);
        this.rngPanel.setEnabled(true);
        this.keepLabel.setEnabled(true);
        this.keepBox.setEnabled(true);
        this.rngLabel.setEnabled(true);
        this.rngBox.setEnabled(true);
        this.seedLabel.setEnabled(this.rngBox.isSelected());
        this.seedField.setEnabled(this.rngBox.isSelected());
        this.verticesLolliLabel.setEnabled(false);
        this.verticesLolliField.setEnabled(false);
        this.degreeKLabel.setEnabled(false);
        this.degreeKField.setEnabled(false);
    }

    private void fixedEdgeProb() {
        this.edgesLabel.setEnabled(false);
        this.edgesField.setEnabled(false);
        this.probabilityLabel.setEnabled(true);
        this.probabilityField.setEnabled(true);
        this.weightLabel.setEnabled(true);
        this.weightField.setEnabled(true);
        this.trianglesLabel.setEnabled(false);
        this.trianglesField.setEnabled(false);
        this.keepLabel.setEnabled(true);
        this.keepBox.setEnabled(true);
        this.rngPanel.setEnabled(true);
        this.rngLabel.setEnabled(true);
        this.rngBox.setEnabled(true);
        this.seedLabel.setEnabled(this.rngBox.isSelected());
        this.seedField.setEnabled(this.rngBox.isSelected());
        this.verticesLolliLabel.setEnabled(false);
        this.verticesLolliField.setEnabled(false);
        this.degreeKLabel.setEnabled(false);
        this.degreeKField.setEnabled(false);
    }

    private void fixedEdgeBinVal() {
        this.edgesLabel.setEnabled(false);
        this.edgesField.setEnabled(false);
        this.probabilityLabel.setEnabled(true);
        this.probabilityField.setEnabled(true);
        this.weightLabel.setEnabled(false);
        this.weightField.setEnabled(false);
        this.trianglesLabel.setEnabled(false);
        this.trianglesField.setEnabled(false);
        this.keepLabel.setEnabled(true);
        this.keepBox.setEnabled(true);
        this.rngPanel.setEnabled(true);
        this.rngLabel.setEnabled(true);
        this.rngBox.setEnabled(true);
        this.seedLabel.setEnabled(this.rngBox.isSelected());
        this.seedField.setEnabled(this.rngBox.isSelected());
        this.verticesLolliLabel.setEnabled(false);
        this.verticesLolliField.setEnabled(false);
        this.degreeKLabel.setEnabled(false);
        this.degreeKField.setEnabled(false);
    }

    private void fullGraph() {
        this.edgesLabel.setEnabled(false);
        this.edgesField.setEnabled(false);
        this.probabilityLabel.setEnabled(false);
        this.probabilityField.setEnabled(false);
        this.weightLabel.setEnabled(true);
        this.weightField.setEnabled(true);
        this.trianglesLabel.setEnabled(false);
        this.trianglesField.setEnabled(false);
        this.keepLabel.setEnabled(true);
        this.keepBox.setEnabled(true);
        this.rngPanel.setEnabled(true);
        this.rngLabel.setEnabled(true);
        this.rngBox.setEnabled(true);
        this.seedLabel.setEnabled(this.rngBox.isSelected());
        this.seedField.setEnabled(this.rngBox.isSelected());
        this.verticesLolliLabel.setEnabled(false);
        this.verticesLolliField.setEnabled(false);
        this.degreeKLabel.setEnabled(false);
        this.degreeKField.setEnabled(false);
    }

    private void path() {
        this.edgesLabel.setEnabled(false);
        this.edgesField.setEnabled(false);
        this.probabilityLabel.setEnabled(false);
        this.probabilityField.setEnabled(false);
        this.weightLabel.setEnabled(false);
        this.weightField.setEnabled(false);
        this.trianglesLabel.setEnabled(false);
        this.trianglesField.setEnabled(false);
        this.keepLabel.setEnabled(false);
        this.keepBox.setEnabled(false);
        this.rngPanel.setEnabled(false);
        this.rngLabel.setEnabled(false);
        this.rngBox.setEnabled(false);
        this.seedLabel.setEnabled(this.rngBox.isSelected());
        this.seedField.setEnabled(this.rngBox.isSelected());
        this.verticesLolliLabel.setEnabled(false);
        this.verticesLolliField.setEnabled(false);
        this.degreeKLabel.setEnabled(false);
        this.degreeKField.setEnabled(false);
    }

    private void randomTree() {
        this.edgesLabel.setEnabled(false);
        this.edgesField.setEnabled(false);
        this.probabilityLabel.setEnabled(false);
        this.probabilityField.setEnabled(false);
        this.weightLabel.setEnabled(false);
        this.weightField.setEnabled(false);
        this.trianglesLabel.setEnabled(false);
        this.trianglesField.setEnabled(false);
        this.keepLabel.setEnabled(true);
        this.keepBox.setEnabled(true);
        this.rngPanel.setEnabled(true);
        this.rngLabel.setEnabled(true);
        this.rngBox.setEnabled(true);
        this.seedLabel.setEnabled(this.rngBox.isSelected());
        this.seedField.setEnabled(this.rngBox.isSelected());
        this.verticesLolliLabel.setEnabled(false);
        this.verticesLolliField.setEnabled(false);
        this.degreeKLabel.setEnabled(false);
        this.degreeKField.setEnabled(false);
    }

    private void ingosGraph() {
        this.edgesLabel.setEnabled(false);
        this.edgesField.setEnabled(false);
        this.probabilityLabel.setEnabled(false);
        this.probabilityField.setEnabled(false);
        this.weightLabel.setEnabled(false);
        this.weightField.setEnabled(false);
        this.trianglesLabel.setEnabled(true);
        this.trianglesField.setEnabled(true);
        this.rngPanel.setEnabled(false);
        this.keepLabel.setEnabled(false);
        this.keepBox.setEnabled(false);
        this.rngLabel.setEnabled(false);
        this.rngBox.setEnabled(false);
        this.seedLabel.setEnabled(false);
        this.seedField.setEnabled(false);
        this.verticesLolliLabel.setEnabled(false);
        this.verticesLolliField.setEnabled(false);
        this.degreeKLabel.setEnabled(false);
        this.degreeKField.setEnabled(false);
    }

    private void lollipop() {
        this.edgesLabel.setEnabled(false);
        this.edgesField.setEnabled(false);
        this.probabilityLabel.setEnabled(false);
        this.probabilityField.setEnabled(false);
        this.weightLabel.setEnabled(false);
        this.weightField.setEnabled(false);
        this.trianglesLabel.setEnabled(false);
        this.trianglesField.setEnabled(false);
        this.rngPanel.setEnabled(false);
        this.keepLabel.setEnabled(false);
        this.keepBox.setEnabled(false);
        this.rngLabel.setEnabled(false);
        this.rngBox.setEnabled(false);
        this.seedLabel.setEnabled(this.rngBox.isSelected());
        this.seedField.setEnabled(this.rngBox.isSelected());
        this.verticesLolliLabel.setEnabled(true);
        this.verticesLolliField.setEnabled(true);
        this.degreeKLabel.setEnabled(false);
        this.degreeKField.setEnabled(false);
    }

    private void k_tree() {
        this.edgesLabel.setEnabled(false);
        this.edgesField.setEnabled(false);
        this.probabilityLabel.setEnabled(false);
        this.probabilityField.setEnabled(false);
        this.weightLabel.setEnabled(false);
        this.weightField.setEnabled(false);
        this.trianglesLabel.setEnabled(false);
        this.trianglesField.setEnabled(false);
        this.rngPanel.setEnabled(false);
        this.keepLabel.setEnabled(false);
        this.keepBox.setEnabled(false);
        this.rngLabel.setEnabled(false);
        this.rngBox.setEnabled(false);
        this.seedLabel.setEnabled(this.rngBox.isSelected());
        this.seedField.setEnabled(this.rngBox.isSelected());
        this.verticesLolliLabel.setEnabled(false);
        this.verticesLolliField.setEnabled(false);
        this.degreeKLabel.setEnabled(true);
        this.degreeKField.setEnabled(true);
    }

    private void semi() {
        this.edgesLabel.setEnabled(true);
        this.edgesField.setEnabled(true);
        this.probabilityLabel.setEnabled(false);
        this.probabilityField.setEnabled(false);
        this.weightLabel.setEnabled(false);
        this.weightField.setEnabled(false);
        this.trianglesLabel.setEnabled(false);
        this.trianglesField.setEnabled(false);
        this.rngPanel.setEnabled(true);
        this.keepLabel.setEnabled(true);
        this.keepBox.setEnabled(true);
        this.rngLabel.setEnabled(true);
        this.rngBox.setEnabled(true);
        this.seedLabel.setEnabled(this.rngBox.isSelected());
        this.seedField.setEnabled(this.rngBox.isSelected());
        this.verticesLolliLabel.setEnabled(false);
        this.verticesLolliField.setEnabled(false);
        this.degreeKLabel.setEnabled(false);
        this.degreeKField.setEnabled(false);
    }

    private void semiP() {
        this.edgesLabel.setEnabled(true);
        this.edgesField.setEnabled(true);
        this.probabilityLabel.setEnabled(true);
        this.probabilityField.setEnabled(true);
        this.weightLabel.setEnabled(false);
        this.weightField.setEnabled(false);
        this.trianglesLabel.setEnabled(false);
        this.trianglesField.setEnabled(false);
        this.rngPanel.setEnabled(true);
        this.keepLabel.setEnabled(true);
        this.keepBox.setEnabled(true);
        this.rngLabel.setEnabled(true);
        this.rngBox.setEnabled(true);
        this.seedLabel.setEnabled(this.rngBox.isSelected());
        this.seedField.setEnabled(this.rngBox.isSelected());
        this.verticesLolliLabel.setEnabled(false);
        this.verticesLolliField.setEnabled(false);
        this.degreeKLabel.setEnabled(false);
        this.degreeKField.setEnabled(false);
    }

    private void trapLine() {
        this.edgesLabel.setEnabled(false);
        this.edgesField.setEnabled(false);
        this.probabilityLabel.setEnabled(false);
        this.probabilityField.setEnabled(false);
        this.weightLabel.setEnabled(false);
        this.weightField.setEnabled(false);
        this.trianglesLabel.setEnabled(false);
        this.trianglesField.setEnabled(false);
        this.rngPanel.setEnabled(false);
        this.keepLabel.setEnabled(false);
        this.keepBox.setEnabled(false);
        this.rngLabel.setEnabled(false);
        this.rngBox.setEnabled(false);
        this.seedLabel.setEnabled(false);
        this.seedField.setEnabled(false);
        this.verticesLolliLabel.setEnabled(false);
        this.verticesLolliField.setEnabled(false);
        this.degreeKLabel.setEnabled(false);
        this.degreeKField.setEnabled(false);
    }
}

