/*
 * Decompiled with CFR 0.152.
 */
package freak.module.view.plotter;

import freak.core.control.Schedule;
import freak.core.event.BatchEvent;
import freak.core.event.BatchEventListener;
import freak.core.event.EventListener;
import freak.core.event.RunEvent;
import freak.core.event.RunEventListener;
import freak.core.observer.Observer;
import freak.core.view.HistoryView;
import freak.core.view.ObserverUnknownException;
import freak.core.view.swingsupport.FreakSwingModel;
import freak.core.view.swingsupport.SlidingWindow;
import freak.core.view.swingsupport.UpdateManager;
import freak.module.view.plotter.AbstractPlotterPanel;
import freak.module.view.plotter.AdjustingPlotterPanel;
import freak.module.view.plotter.DecreasingXValueException;
import freak.module.view.plotter.ExpandingPlotterPanel;
import freak.module.view.plotter.Point;
import freak.module.view.plotter.PointList;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.lang.reflect.Array;
import java.util.TreeSet;
import javax.swing.JPanel;

public class Plotter
extends HistoryView
implements FreakSwingModel,
BatchEventListener,
RunEventListener {
    private transient JPanel wrapperPanel;
    private transient AbstractPlotterPanel plotterPanel;
    public static final int GRID_XSPACE = 60;
    public static final int GRID_YSPACE = 30;
    Color pointColor = Color.black;
    SlidingWindow xValues;
    TreeSet yValues;
    boolean shrinkYAxis = true;
    boolean useConstantXSpace;
    boolean showLines = true;
    int xAxisMin;
    int xAxisMax;
    double yAxisLowerBound;
    double yAxisUpperBound;
    int currentXValue;
    double constantGenXSpace;

    public Plotter(Schedule schedule) {
        super(schedule);
        this.setPropertyNumberOfDisplayedValues(new Integer(500));
        this.pointColor = Color.black;
        this.useConstantXSpace = false;
        this.constantGenXSpace = 1.0;
        this.plotterPanel = null;
    }

    public JPanel createPanel() {
        this.wrapperPanel = new JPanel();
        this.wrapperPanel.setLayout(new BorderLayout());
        if (this.useConstantXSpace) {
            this.setPlotterPanel(new ExpandingPlotterPanel(this));
        } else {
            this.setPlotterPanel(new AdjustingPlotterPanel(this));
        }
        return this.wrapperPanel;
    }

    private void setPlotterPanel(AbstractPlotterPanel plotterPanel) {
        this.plotterPanel = plotterPanel;
        this.wrapperPanel.removeAll();
        this.wrapperPanel.add((Component)plotterPanel, "Center");
    }

    public Class[] getInputDataTypes() {
        return new Class[]{Number.class, byte[].class, short[].class, int[].class, long[].class, float[].class, double[].class};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(Object o) {
        Plotter plotter = this;
        synchronized (plotter) {
            super.update(o);
            double[] numbers = null;
            if (o instanceof Number) {
                numbers = new double[]{((Number)o).doubleValue()};
            } else {
                int length = Array.getLength(o);
                numbers = new double[length];
                int i = 0;
                while (i < length) {
                    numbers[i] = Array.getDouble(o, i);
                    ++i;
                }
            }
            this.appendData(numbers);
        }
        UpdateManager.markDirty(this);
    }

    public void flush() {
        this.plotterPanel.flush();
    }

    public String getName() {
        return "Plotter";
    }

    public String getDescription() {
        return "A simple plotter rendering the observed values over time.";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runStarted(RunEvent evt) {
        block5: {
            try {
                if (this.getObserver().getMeasure() != 1) break block5;
                Plotter plotter = this;
                synchronized (plotter) {
                    this.clearData();
                    this.initAxes();
                }
                UpdateManager.markDirty(this);
            }
            catch (ObserverUnknownException e) {
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void batchStarted(BatchEvent evt) {
        block5: {
            try {
                if (this.getObserver().getMeasure() != 2) break block5;
                Plotter plotter = this;
                synchronized (plotter) {
                    this.clearData();
                    this.initAxes();
                }
                UpdateManager.markDirty(this);
            }
            catch (ObserverUnknownException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void createEvents() {
        this.schedule.getEventController().addEvent((EventListener)this, RunEvent.class, this.schedule);
        this.schedule.getEventController().addEvent((EventListener)this, BatchEvent.class, this.schedule);
    }

    private void appendData(double[] data) {
        try {
            if (this.getCurrentValue() < this.currentXValue) {
                throw new DecreasingXValueException("The plotter can only handle nondecreasing x values.");
            }
            int newxAxisMax = Math.max(this.xAxisMax, this.getCurrentValue());
            int newxAxisMin = this.numberOfDisplayedValues == 0 ? this.xAxisMin : Math.max(this.xAxisMin, newxAxisMax - this.numberOfDisplayedValues + 1);
            this.adjustXAxis(newxAxisMin, newxAxisMax);
            this.currentXValue = this.getCurrentValue();
            if (this.plotterPanel.isXPositionVisible(this.currentXValue)) {
                this.addPoints(this.currentXValue, data);
            }
        }
        catch (ObserverUnknownException e) {
            throw new RuntimeException(e);
        }
    }

    private void removePointsInInterval(int a, int b) {
        if (a < b && this.xValues != null && this.yValues != null) {
            while (this.xValues.size() > 0 && ((PointList)this.xValues.get((int)0)).x < b) {
                PointList oldPoints = (PointList)this.xValues.get(0);
                this.xValues.removeFirst();
                int i = 0;
                while (i < oldPoints.data.length) {
                    this.yValues.remove(oldPoints.data[i]);
                    ++i;
                }
            }
            if (this.shrinkYAxis && this.yValues.size() > 0) {
                this.adjustYAxis(((Point)this.yValues.first()).y, ((Point)this.yValues.last()).y);
            }
        }
    }

    private void addPoints(int x, double[] data) {
        Point[] points = new Point[data.length];
        int i = 0;
        while (i < data.length) {
            points[i] = new Point(x, data[i]);
            this.addPoint(points[i]);
            ++i;
        }
        PointList list = new PointList(x, points);
        this.xValues.add(list);
    }

    private void addPoint(Point point) {
        this.yValues.add(point);
        double lowestValue = ((Point)this.yValues.first()).y;
        double highestValue = ((Point)this.yValues.last()).y;
        if (this.shrinkYAxis) {
            this.adjustYAxis(lowestValue, highestValue);
        } else {
            this.adjustYAxis(Math.min(this.yAxisLowerBound, lowestValue), Math.max(this.yAxisUpperBound, highestValue));
        }
    }

    public void clearData() {
        this.xValues = new SlidingWindow();
        this.yValues = new TreeSet();
    }

    public void initAxes() throws ObserverUnknownException, NullPointerException {
        this.yAxisLowerBound = 0.0;
        this.yAxisUpperBound = 1.0;
        this.xAxisMin = this.getCurrentValue();
        if (this.plotterPanel == null) {
            throw new NullPointerException("PlotterPanel is null.");
        }
        this.xAxisMax = this.xAxisMin + this.plotterPanel.getStartingGenerations() - 1;
        this.currentXValue = this.xAxisMin;
    }

    private void adjustXAxis(int lower, int upper) {
        this.removePointsInInterval(this.xAxisMin, lower);
        this.xAxisMin = lower;
        this.xAxisMax = upper;
    }

    private void adjustYAxis(double lower, double upper) {
        this.yAxisLowerBound = lower;
        this.yAxisUpperBound = upper;
        if (this.yAxisLowerBound == this.yAxisUpperBound) {
            this.yAxisLowerBound -= 0.5;
            this.yAxisUpperBound += 0.5;
        }
    }

    public void setPropertyShowLines(Boolean lines) {
        this.showLines = lines;
    }

    public Boolean getPropertyShowLines() {
        return new Boolean(this.showLines);
    }

    public String getShortDescriptionForShowLines() {
        return "Show lines";
    }

    public String getLongDescriptionForShowLines() {
        return "Set to connect the points by colored lines.";
    }

    public void setPropertyColor(Color color) {
        if (color != null) {
            this.pointColor = color;
        }
    }

    public Color getPropertyColor() {
        return this.pointColor;
    }

    public String getShortDescriptionForColor() {
        return "Color of points";
    }

    public String getLongDescriptionForColor() {
        return "Sets the color for the displayed points.";
    }

    public void setPropertyShrinkYAxis(Boolean shrink) {
        this.shrinkYAxis = shrink;
    }

    public Boolean getPropertyShrinkYAxis() {
        return new Boolean(this.shrinkYAxis);
    }

    public String getShortDescriptionForShrinkYAxis() {
        return "Shrink y axis automatically";
    }

    public String getLongDescriptionForShrinkYAxis() {
        return "When enabled, the y axis is shrunk automatically every time an old maximum or minimum value perishes. When disabled, the y axis is just expanded automatically.";
    }

    public void setPropertyFitWindow(Boolean fit) {
        this.useConstantXSpace = fit;
        if (this.plotterPanel != null) {
            if (this.useConstantXSpace) {
                this.setPlotterPanel(new ExpandingPlotterPanel(this));
            } else {
                this.setPlotterPanel(new AdjustingPlotterPanel(this));
            }
        }
    }

    public Boolean getPropertyFitWindow() {
        return new Boolean(this.useConstantXSpace);
    }

    public String getShortDescriptionForFitWindow() {
        return "Scroll mode";
    }

    public String getLongDescriptionForFitWindow() {
        return "When enabled, only parts of the drawing area are shown. When disabled, all points are fit into the current window.";
    }

    public void setPropertyXSpace(Double space) {
        if (space > 0.0) {
            this.constantGenXSpace = space;
        }
        if (this.plotterPanel != null) {
            this.plotterPanel.flush();
        }
    }

    public Double getPropertyXSpace() {
        return new Double(this.constantGenXSpace);
    }

    public String getShortDescriptionForXSpace() {
        return "Space in x direction";
    }

    public String getLongDescriptionForXSpace() {
        return "The space between two x values on the x axis in pixels. This property is only used if scroll mode is enabled.";
    }

    public void setObserver(Observer observer) {
        super.setObserver(observer);
        if (observer != null) {
            try {
                if (this.plotterPanel == null) {
                    this.createPanel();
                }
                this.clearData();
                this.initAxes();
            }
            catch (ObserverUnknownException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void setPropertyNumberOfDisplayedValues(Integer number) {
        super.setPropertyNumberOfDisplayedValues(number);
        int newxAxisMax = Math.max(this.currentXValue, this.xAxisMin + this.numberOfDisplayedValues - 1);
        int newxAxisMin = this.numberOfDisplayedValues == 0 ? this.xAxisMin : Math.max(this.xAxisMin, newxAxisMax - this.numberOfDisplayedValues + 1);
        this.adjustXAxis(newxAxisMin, newxAxisMax);
    }
}

