% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/profiles.R
\name{list_profiles}
\alias{list_profiles}
\title{Views (Profiles)}
\usage{
list_profiles(account.id = "~all", webproperty.id = "~all",
  start.index = NULL, max.results = NULL, token)
}
\arguments{
\item{account.id}{character. Account ID for the view (profiles) to retrieve. Can either be a specific account ID or '~all', which refers to all the accounts to which the user has access.}

\item{webproperty.id}{character. Web property ID for the views (profiles) to retrieve. Can either be a specific web property ID or '~all', which refers to all the web properties to which the user has access.}

\item{start.index}{integer. An index of the first entity to retrieve. Use this parameter as a pagination mechanism along with the max-results parameter.}

\item{max.results}{integer. The maximum number of views (profiles) to include in this response.}

\item{token}{\code{\link[httr]{Token2.0}} class object with a valid authorization data.}
}
\value{
The Profiles collection is a set of Profile resources, each of which describes the profile of an authenticated user.
\item{id}{View (Profile) ID.}
\item{kind}{Resource type for Analytics view (profile).}
\item{account.id}{Account ID to which this view (profile) belongs.}
\item{webproperty.id}{Web property ID of the form UA-XXXXX-YY to which this view (profile) belongs.}
\item{internal.webproperty.id}{Internal ID for the web property to which this view (profile) belongs.}
\item{name}{Name of this view (profile).}
\item{currency}{The currency type associated with this view (profile), defaults to USD. The supported values are:  ARS,  AUD,  BGN,  BRL,  CAD,  CHF,  CNY,  CZK,  DKK,  EUR, GBP,  HKD,  HUF,  IDR,  INR,  JPY,  KRW,  LTL,  MXN,  NOK, NZD,  PHP,  PLN,  RUB,  SEK,  THB,  TRY,  TWD,  USD,  VND, ZAR}
\item{timezone}{Time zone for which this view (profile) has been configured. Time zones are identified by strings from the TZ database.}
\item{website.url}{Website URL for this view (profile).}
\item{default.page}{Default page for this view (profile).}
\item{exclude.query.parameters}{The query parameters that are excluded from this view (profile).}
\item{site.search.query.parameters}{The site search query parameters for this view (profile).}
\item{strip.site.search.query.parameters}{Whether or not Analytics will strip search query parameters from the URLs in your reports.}
\item{site.search.category.parameters}{Site search category parameters for this view (profile).}
\item{strip.site.search.category.parameters}{Whether or not Analytics will strip search category parameters from the URLs in your reports.}
\item{type}{View (Profile) type. Supported types: WEB or APP.}
\item{permissions}{Permissions the user has for this view (profile).}
\item{created}{Time this view (profile) was created.}
\item{updated}{Time this view (profile) was last modified.}
\item{e.commerce.tracking}{Indicates whether ecommerce tracking is enabled for this view (profile).}
\item{enhanced.e.commerce.tracking}{Indicates whether enhanced ecommerce tracking is enabled for this view (profile). This property can only be enabled if ecommerce tracking is enabled. This property cannot be set on insert.}
\item{bot.filtering.enabled}{Indicates whether bot filtering is enabled for this view (profile).}
\item{permissions.effective}{All the permissions that the user has for this view (profile). These include any implied permissions (e.g., EDIT implies VIEW) or inherited permissions from the parent web property.}
}
\description{
Lists views (profiles) to which the user has access.
}
\references{
\href{https://developers.google.com/analytics/devguides/config/mgmt/v3/mgmtReference/management/profiles}{Management API - Views (Profiles) Overview}
}
\seealso{
Other Management API: \code{\link{get_custom_dimension}},
  \code{\link{get_custom_metric}},
  \code{\link{get_experiment}}, \code{\link{get_filter}},
  \code{\link{get_goal}}, \code{\link{get_profile}},
  \code{\link{get_unsampled_report}},
  \code{\link{get_upload}}, \code{\link{get_webproperty}},
  \code{\link{list_accounts}},
  \code{\link{list_custom_data_sources}},
  \code{\link{list_custom_dimensions}},
  \code{\link{list_custom_metrics}},
  \code{\link{list_experiments}},
  \code{\link{list_filters}}, \code{\link{list_goals}},
  \code{\link{list_segments}},
  \code{\link{list_unsampled_reports}},
  \code{\link{list_uploads}},
  \code{\link{list_webproperties}}
}

