% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kuttner.R
\name{KuttnerModel}
\alias{KuttnerModel}
\title{Kuttner model}
\usage{
KuttnerModel(
  tsl,
  cycle = "AR2",
  cycleLag = 1,
  trend = "RW1",
  inflErrorARMA = c(0, 3),
  start = NULL,
  end = NULL,
  anchor = NULL,
  anchor.h = NULL
)
}
\arguments{
\item{tsl}{A list of time series objects, see details.}

\item{cycle}{A character string specifying the cycle model. \code{cycle = "AR1"} denotes
an AR(1) process, \code{cycle = "AR2"} an AR(2) process. The default is
\code{cycle = "AR2"}.}

\item{cycleLag}{A non-negative integer specifying the maximum cycle lag that is included
in the inflation equation. The default is \code{cycleLag = 0}, see details.}

\item{trend}{A character string specifying the trend model. \code{trend = "RW1"} denotes
a first order random walk, \code{trend = "RW2"} a second order random walk (local linear
trend) and \code{trend = "DT"} a damped trend model. The default is \code{trend = "RW1"}.}

\item{inflErrorARMA}{A \code{2 x 1} vector with non-negative integers specifying the AR
and MA degree of the error term in the inflation equation. The default is
\code{inflErrorARMA = c(0, 3)}, see details.}

\item{start}{(Optional) Start vector for the estimation, e.g. \code{c(1980, 1)}.}

\item{end}{(Optional) End vector for the estimation, e.g. \code{c(2020, 1)}.}

\item{anchor}{(Optional) Anchor value for the logarithm of trend gdp.}

\item{anchor.h}{(Optional) Anchor horizon in the frequency of the given time series.}
}
\value{
Object of class \code{KuttnerModel}, which is a list with the following components:
  \item{tsl}{A list of used time series.}
  \item{SSModel}{An object of class SSModel specifying the state-space model.}
  \item{loc}{A data frame containing information on each involved parameter, for instance
        its corresponding system matrix, variable names, and parameter restrictions.}
  \item{call}{Original call to the function. }
  In addition, the object contains the following attributes:
  \item{cycle}{Cycle specification.}
  \item{trend}{Trend specification.}
  \item{inflation equation}{A list containing the components \code{cycleLag, errorARMA, exoVariables}.}
  \item{anchor}{A list containing the components \code{value, horizon}.}
  \item{period}{A list containing the components \code{start, end, frequency}.}
}
\description{
Creates a state space object object of class \code{KuttnerModel} which can be 
  fitted using \code{fit}.
}
\details{
The list of time series \code{tsl} needs to have the following components:
\describe{
  \item{gdp}{Real gross domestic product.}
  \item{infl}{Inflation.}
  }

A \code{cycleLag} equal to \code{0} implies that only the contemporaneous cycle
  is included in the inflation equation.  A \code{cycleLag} equal to \code{0:1} implies that
  the contemporaneous as well as the lagged cycle are included.

A \code{inflErrorARMA} equal to \code{c(0, 0)} implies that the error term in the
  inflation equation is white noise. \code{inflErrorARMA = c(1, 0)} implies that the error is
  an AR(1) process and for \code{inflErrorARMA = c(1, 2)} the error follows an ARMA(1, 2)
  process.
}
\examples{
# load data for the Netherlands
data("gap")
country <- "Netherlands"
tsList <- as.list(gap[[country]][, c("cpih", "gdp")])
tsList$infl <- diff(tsList$cpih)
model <- KuttnerModel(tsl = tsList, trend = "RW2", start = 1980)
}
