% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checks.R
\name{.checkTfp}
\alias{.checkTfp}
\title{Checks the input variables for the procedure \code{TFPmodel} for consistency and validity.}
\usage{
.checkTfp(
  tsl,
  trend,
  cycle,
  cycleLag,
  cubsAR,
  errorARMA,
  start,
  end,
  anchor,
  anchor.h
)
}
\arguments{
\item{tsl}{A list of time series objects, see details.}

\item{trend}{A character string specifying the trend model. \code{trend = "RW1"} denotes
a first order random walk, \code{trend = "RW2"} a second order random walk (local linear
trend) and \code{trend = "DT"} a damped trend model. The default is \code{trend = "DT"}.}

\item{cycle}{A character string specifying the cycle model. \code{cycle = "AR1"} denotes
an AR(1) process, \code{cycle = "AR2"} an AR(2) process, \code{cycle = "RAR2"} a
reparametrized AR(2) process. The default is \code{cycle = "AR2"}.}

\item{cycleLag}{A non-negative integer specifying the maximum cycle lag that is included
in the CUBD equation. The default is \code{cycleLag = 0}, see details.}

\item{cubsAR}{A non-negative integer specifying the maximum CUBS lag that is included
in the CUBS equation. The default is \code{cubsAR = 0}, see details.}

\item{errorARMA}{A vector with non-negative integers specifying the AR
and MA degree of the error term in the CUBS equation.}

\item{start}{(Optional) Start vector for the estimation, e.g. \code{c(1980, 1)}.}

\item{end}{(Optional) End vector for the estimation, e.g. \code{c(2020, 1)}.}

\item{anchor}{(Optional) Snchor value for the log of the TFP trend.}

\item{anchor.h}{(Optional) Anchor horizon in the frequency of the given time series.}
}
\description{
Checks the input variables for the procedure \code{TFPmodel} for consistency and validity.
}
\keyword{internal}
