% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.cval.R
\name{plot.cval}
\alias{plot.cval}
\title{Plot for cross-validation}
\usage{
\method{plot}{cval}(
  x,
  type = "sd",
  cex = 1,
  cex_main = 14 * cex,
  cex_sub = 12 * cex,
  cex_point = 3 * cex,
  cex_lab = 12 * cex,
  display_order = TRUE,
  ...
)
}
\arguments{
\item{x}{A rgcca_cv object (see \link{rgcca_cv})}

\item{type}{A string indicating the statistics depicted in the boxplot:
\itemize{
\item "sd" (default): the middle bar corresponds to the mean and limits of
the boxes are given by the mean plus or minus the standard deviation.
\item "quantile": the middle bar corresponds to the median and limits of
the boxes are given by the 25\% and 75\% quantiles.
}}

\item{cex}{A numeric defining the size of the objects in the plot. Default
is one.}

\item{cex_main}{A numeric defining the font size of the title. Default is
14 * cex.}

\item{cex_sub}{A numeric defining the font size of the subtitle. Default is
12 * cex.}

\item{cex_point}{A numeric defining the font size of the points. Default is
3 * cex.}

\item{cex_lab}{A numeric defining the font size of the labels. Default is
12 * cex.}

\item{display_order}{A logical value for ordering the variables. If TRUE,
variables are ordered from highest to lowest absolute value. If FALSE,
the block order is used. Default is TRUE.}

\item{...}{Additional graphical parameters.}
}
\value{
A ggplot2 plot object.
}
\description{
Plot a fitted cross-validation object.
The parameters tuned for maximizing the cross-validated score is
displayed in the title. The set of candidate tuning parameters
are represented on the y-axis. A boxplot of the cross-validated scores are
displayed on the x-axis.
}
\examples{
data("Russett")
blocks <- list(
  agriculture = Russett[, seq(3)],
  industry = Russett[, 4:5],
  politic = as.factor(apply(Russett[, 9:11], 1, which.max))
)
cv_out <- rgcca_cv(blocks,
  response = 3, method = "rgcca",
  par_type = "tau",
  par_value = 1,
  n_run = 1, n_cores = 1,
  prediction_model = "lda",
  metric = "Accuracy",
  verbose = FALSE
)

print(cv_out)
plot(cv_out)
}
