% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.rgcca.R
\name{print.rgcca}
\alias{print.rgcca}
\title{Print the call of rgcca results}
\usage{
\method{print}{rgcca}(x, ...)
}
\arguments{
\item{x}{A RGCCA object (see \code{\link{rgcca}})}

\item{...}{Other parameters used in print (for the displaying of matrices).}
}
\value{
none
}
\description{
Print a RGCCA object
}
\details{
Print a fitted RGCCA object. Some information about the model are
displayed like model parameters or criterion.
}
\examples{
data(Russett)
X_agric <- as.matrix(Russett[, c("gini", "farm", "rent")])
X_ind <- as.matrix(Russett[, c("gnpr", "labo")])
X_polit <- as.matrix(Russett[, c("demostab", "dictator")])
A <- list(X_agric, X_ind, X_polit)
C <- matrix(c(0, 0, 1, 0, 0, 1, 1, 1, 0), 3, 3)
res <- rgcca(A,
  connection = C, ncomp = rep(2, 3), tau = c(1, 1, 1),
  scheme = "factorial", scale = TRUE, verbose = FALSE
)
print(res)
}
