% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/senDownload.R
\name{senDownload}
\alias{senDownload}
\title{Search and download Sentinel images}
\usage{
senDownload(username, password, AppRoot, verbose = FALSE, ...)
}
\arguments{
\item{username}{ESA’s `SciHub' username.}

\item{password}{ESA’s `SciHub' password.}

\item{AppRoot}{the directory where the images are saved.}

\item{verbose}{logical argument. If \code{TRUE}, the function prints the 
running steps and warnings.}

\item{...}{arguments for nested functions:
\itemize{
  \item \code{product} the type of Sentinel product. Ex. "S2MSI1C",
  "S2MSI2A", "S2MSI2Ap", ... 
  \item \code{startDate} a \code{Date} class object with the starting date of
  the study period.
  \item \code{endDate} a \code{Date} class object with the ending date of
   the study period.
  \item \code{extent} an \code{extent}, \code{Raster*}, or \code{Spatial*}
  object representing the region of interest with longitude/latitude
  coordinates.
  \item \code{platform} the name of the Sentinel mission ("Sentinel-1", 
  "Sentinel-2", ...).
  \item \code{nattempts} the number of attempts to download an image in case
  it becomes corrupted.
  \item \code{unzip} logical argument. If \code{TRUE}, unzips the images.
  \item \code{verbose} logical argument. If \code{TRUE}, the function prints
  the running steps and warnings.
}}
}
\description{
\code{senDownload} searches and downloads Sentinel images concerning a
particular location and time interval from `SciHub's' repository.
}
\details{
\code{senDonwload} is a wrapper function of \code{\link{senSearch}} and 
\code{\link{senDownSearch}} to search and download images in a single step.
The function requires ESA’s `SciHub' credentials, which can be obtained
\href{https://scihub.copernicus.eu/dhus/#/self-registration}{here}.
}
\examples{
\dontrun{
# load a spatial polygon object of Navarre
data(ex.navarre)
# Download S2MSI1C products sensed by Sentinel-2 
# between the julian dates 210 and 218, 2018
src <- paste0(tempdir(),"/Path_for_downloading_folder")
print(src)
senDownload(startDate = as.Date("2018210", "\%Y\%j"),
            endDate = as.Date("2018218", "\%Y\%j"),
            platform = "Sentinel-2",
            extent = ex.navarre,
            product = "S2MSI1C",
            pathrow = c("R094"),
            username = "username",
            password = "password",
            AppRoot = src)
            
src.sen <- file.path(src, "Sentinel-2")
src.sen.unzip <- file.path(src.sen, "unzip")
                  
files <- list.files(src.unzip,
                    pattern = "\\\\TCI.jp2$",
                    full.names = TRUE,
                    recursive = TRUE)
rgb <- stack(files[1])
plotRGB(rgb)
}
}
