% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lsEspaUpdateOrders.R
\name{lsEspaUpdateOrders}
\alias{lsEspaUpdateOrders}
\title{Updates the status of a request made to ESPA}
\usage{
lsEspaUpdateOrders(orders, username = NULL, password = NULL,
  c.handle = NULL, verbose = FALSE)
}
\arguments{
\item{orders}{a list of the requested orders as returned by
\code{\link{lsEspaGetOrderImages}}.}

\item{username}{USGS's `EarthExplorer' username.}

\item{password}{USGS's `EarthExplorer' password.}

\item{c.handle}{a curl handler created with the package `\code{curl}' to
stablish a connection with a preset password and username. This argument
is mandatory if \code{username} and \code{password} are not defined.}

\item{verbose}{logical argument. If \code{TRUE}, the function prints the
running steps and warnings.}
}
\value{
this function returns a \code{dataframe} with the updated order information from ESPA.
}
\description{
\code{lsEspaUpdateOrders} checks the current status of a request made to EROS
Centre Science Processing Architecture (ESPA) to pre-process Landsat level-1
images
}
\details{
This function is part of a group of functions used to pre-process Landsat
level 1 images. The pre-processing is carried out by ESPA on demand. 
\code{lsEspaUpdateOrders} uses the ID numbers gathered by 
\code{\link{lsEspaGetOrderImages}} regarding previous order requests
to check the processing status. The function has to be run repeatedly 
until the status message states “complete”. All the status messages and their 
interpretation can be found in the ESPA's API 
\href{https://www.usgs.gov/media/files/eros-science-processing-architecture-demand-interface-user-guide}{User Guide}.
}
\examples{
\dontrun{
src <- file.path(tempdir(),"Path_for_downloading_folder")
# search Landsat 7 level-1
search.res <- ls7Search(startDate = as.Date("01-01-2017", "\%d-\%m-\%Y"),
                        endDate = as.Date("15-01-2017", "\%d-\%m-\%Y"),
                        lonlat = c(-1.64323, 42.81687),
                        AppRoot = src)
# request to ESPA the prepocessing of level-1 images to get the surface reflectance
orders <- lsEspaOrderImages(search.res = search.res,
                            username = "username", 
                            password = "password", 
                            product = 'sr',
                            verbose = FALSE)
# get an ID for our request
orders <- lsEspaGetOrderImages(username = "username", 
                               password = "password")
# follow up the status of the request
orders <- lsEspaUpdateOrders(orders = orders,
                             username = "username", 
                             password = "password")
}
}
