/*
 * Decompiled with CFR 0.152.
 */
package org.h2.server.web;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import org.h2.api.DatabaseEventListener;
import org.h2.bnf.Bnf;
import org.h2.constant.SysProperties;
import org.h2.jdbc.JdbcSQLException;
import org.h2.message.Message;
import org.h2.server.web.ConnectionInfo;
import org.h2.server.web.DbColumn;
import org.h2.server.web.DbContents;
import org.h2.server.web.DbSchema;
import org.h2.server.web.DbTableOrView;
import org.h2.server.web.PageParser;
import org.h2.server.web.WebServer;
import org.h2.server.web.WebSession;
import org.h2.tools.Backup;
import org.h2.tools.ChangeFileEncryption;
import org.h2.tools.ConvertTraceFile;
import org.h2.tools.CreateCluster;
import org.h2.tools.DeleteDbFiles;
import org.h2.tools.Recover;
import org.h2.tools.Restore;
import org.h2.tools.RunScript;
import org.h2.tools.Script;
import org.h2.tools.SimpleResultSet;
import org.h2.util.JdbcUtils;
import org.h2.util.MathUtils;
import org.h2.util.MemoryUtils;
import org.h2.util.New;
import org.h2.util.ObjectArray;
import org.h2.util.Profiler;
import org.h2.util.ScriptReader;
import org.h2.util.SortedProperties;
import org.h2.util.StatementBuilder;
import org.h2.util.StringUtils;
import org.h2.util.Tool;

public class WebApp
implements DatabaseEventListener {
    protected WebServer server;
    protected WebSession session;
    protected Properties attributes;
    protected String mimeType;
    protected long listenerLastEvent;
    protected int listenerLastState;
    protected boolean cache;
    protected boolean stop;
    protected String headerLanguage;
    protected Profiler profiler;

    WebApp(WebServer webServer) {
        this.server = webServer;
    }

    void setSession(WebSession webSession, Properties properties) {
        this.session = webSession;
        this.attributes = properties;
    }

    String processRequest(String string, String string2) {
        int n = string.lastIndexOf(46);
        String string3 = n >= 0 ? string.substring(n + 1) : "";
        if ("ico".equals(string3)) {
            this.mimeType = "image/x-icon";
            this.cache = true;
        } else if ("gif".equals(string3)) {
            this.mimeType = "image/gif";
            this.cache = true;
        } else if ("css".equals(string3)) {
            this.cache = true;
            this.mimeType = "text/css";
        } else if ("html".equals(string3) || "do".equals(string3) || "jsp".equals(string3)) {
            this.cache = false;
            this.mimeType = "text/html";
            if (this.session == null) {
                this.session = this.server.createNewSession(string2);
                if (!"notAllowed.jsp".equals(string)) {
                    string = "index.do";
                }
            }
        } else if ("js".equals(string3)) {
            this.cache = true;
            this.mimeType = "text/javascript";
        } else {
            this.cache = false;
            this.mimeType = "text/html";
            string = "error.jsp";
            this.trace("Unknown mime type, file " + string);
        }
        this.trace("mimeType=" + this.mimeType);
        this.trace(string);
        if (string.endsWith(".do")) {
            string = this.process(string);
        }
        return string;
    }

    private String getComboBox(String[] stringArray, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string2 : stringArray) {
            stringBuilder.append("<option value=\"").append(PageParser.escapeHtmlData(string2)).append("\"");
            if (string2.equals(string)) {
                stringBuilder.append(" selected");
            }
            stringBuilder.append('>').append(PageParser.escapeHtml(string2)).append("</option>");
        }
        return stringBuilder.toString();
    }

    private String getComboBox(String[][] stringArray, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String[] stringArray2 : stringArray) {
            stringBuilder.append("<option value=\"").append(PageParser.escapeHtmlData(stringArray2[0])).append("\"");
            if (stringArray2[0].equals(string)) {
                stringBuilder.append(" selected");
            }
            stringBuilder.append('>').append(PageParser.escapeHtml(stringArray2[1])).append("</option>");
        }
        return stringBuilder.toString();
    }

    private String process(String string) {
        this.trace("process " + string);
        while (string.endsWith(".do")) {
            if ("login.do".equals(string)) {
                string = this.login();
                continue;
            }
            if ("index.do".equals(string)) {
                string = this.index();
                continue;
            }
            if ("logout.do".equals(string)) {
                string = this.logout();
                continue;
            }
            if ("settingRemove.do".equals(string)) {
                string = this.settingRemove();
                continue;
            }
            if ("settingSave.do".equals(string)) {
                string = this.settingSave();
                continue;
            }
            if ("test.do".equals(string)) {
                string = this.test();
                continue;
            }
            if ("query.do".equals(string)) {
                string = this.query();
                continue;
            }
            if ("tables.do".equals(string)) {
                string = this.tables();
                continue;
            }
            if ("editResult.do".equals(string)) {
                string = this.editResult();
                continue;
            }
            if ("getHistory.do".equals(string)) {
                string = this.getHistory();
                continue;
            }
            if ("admin.do".equals(string)) {
                string = this.admin();
                continue;
            }
            if ("adminSave.do".equals(string)) {
                string = this.adminSave();
                continue;
            }
            if ("adminStartTranslate.do".equals(string)) {
                string = this.adminStartTranslate();
                continue;
            }
            if ("adminShutdown.do".equals(string)) {
                string = this.adminShutdown();
                continue;
            }
            if ("autoCompleteList.do".equals(string)) {
                string = this.autoCompleteList();
                continue;
            }
            if ("tools.do".equals(string)) {
                string = this.tools();
                continue;
            }
            string = "error.jsp";
        }
        this.trace("return " + string);
        return string;
    }

    private String autoCompleteList() {
        String string = (String)this.attributes.get("query");
        boolean bl = false;
        if (string.trim().length() > 0 && Character.isLowerCase(string.trim().charAt(0))) {
            bl = true;
        }
        try {
            String string2;
            String string3 = string;
            if (string3.endsWith(";")) {
                string3 = string3 + " ";
            }
            ScriptReader scriptReader = new ScriptReader(new StringReader(string3));
            scriptReader.setSkipRemarks(true);
            String string4 = "";
            while ((string2 = scriptReader.readStatement()) != null) {
                string4 = string2;
            }
            string2 = "";
            if (scriptReader.isInsideRemark()) {
                string2 = scriptReader.isBlockRemark() ? "1#(End Remark)# */\n" + string2 : "1#(Newline)#\n" + string2;
            } else {
                char c;
                Bnf bnf;
                string3 = string4;
                while (string3.length() > 0 && string3.charAt(0) <= ' ') {
                    string3 = string3.substring(1);
                }
                if (string3.trim().length() > 0 && Character.isLowerCase(string3.trim().charAt(0))) {
                    bl = true;
                }
                if ((bnf = this.session.getBnf()) == null) {
                    return "autoCompleteList.jsp";
                }
                HashMap<String, String> hashMap = bnf.getNextTokenList(string3);
                String string5 = "";
                if (string3.length() > 0 && !Character.isWhitespace(c = string3.charAt(string3.length() - 1)) && c != '.' && c >= ' ' && c != '\'' && c != '\"') {
                    string5 = " ";
                }
                ArrayList<String> arrayList = New.arrayList(hashMap.size());
                for (Map.Entry<String, String> object : hashMap.entrySet()) {
                    String string6 = object.getKey();
                    String string7 = object.getValue();
                    String string8 = "" + string6.charAt(0);
                    if (Character.isLetter((string6 = string6.substring(2)).charAt(0)) && bl) {
                        string6 = StringUtils.toLowerEnglish(string6);
                        string7 = StringUtils.toLowerEnglish(string7);
                    }
                    if (string6.equals(string7) && !".".equals(string7)) {
                        string7 = string5 + string7;
                    }
                    string6 = StringUtils.urlEncode(string6);
                    string6 = StringUtils.replaceAll(string6, "+", " ");
                    string7 = StringUtils.urlEncode(string7);
                    string7 = StringUtils.replaceAll(string7, "+", " ");
                    arrayList.add(string8 + "#" + string6 + "#" + string7);
                }
                Collections.sort(arrayList);
                if (string.endsWith("\n") || string.trim().endsWith(";")) {
                    arrayList.add(0, "1#(Newline)#\n");
                }
                StatementBuilder statementBuilder = new StatementBuilder();
                for (String string6 : arrayList) {
                    statementBuilder.appendExceptFirst("|");
                    statementBuilder.append(string6);
                }
                string2 = statementBuilder.toString();
            }
            this.session.put("autoCompleteList", string2);
        }
        catch (Throwable throwable) {
            this.server.traceError(throwable);
        }
        return "autoCompleteList.jsp";
    }

    private String admin() {
        this.session.put("port", "" + this.server.getPort());
        this.session.put("allowOthers", "" + this.server.getAllowOthers());
        this.session.put("ssl", String.valueOf(this.server.getSSL()));
        this.session.put("sessions", this.server.getSessions());
        return "admin.jsp";
    }

    private String adminSave() {
        try {
            SortedProperties sortedProperties = new SortedProperties();
            int n = MathUtils.decodeInt((String)this.attributes.get("port"));
            sortedProperties.setProperty("webPort", String.valueOf(n));
            this.server.setPort(n);
            boolean bl = Boolean.valueOf((String)this.attributes.get("allowOthers"));
            sortedProperties.setProperty("webAllowOthers", String.valueOf(bl));
            this.server.setAllowOthers(bl);
            boolean bl2 = Boolean.valueOf((String)this.attributes.get("ssl"));
            sortedProperties.setProperty("webSSL", String.valueOf(bl2));
            this.server.setSSL(bl2);
            this.server.saveSettings(sortedProperties);
        }
        catch (Exception exception) {
            this.trace(exception.toString());
        }
        return this.admin();
    }

    private String tools() {
        try {
            String string = (String)this.attributes.get("tool");
            this.session.put("tool", string);
            String string2 = (String)this.attributes.get("args");
            String[] stringArray = StringUtils.arraySplit(string2, ',', false);
            Tool tool = null;
            if ("Backup".equals(string)) {
                tool = new Backup();
            } else if ("Restore".equals(string)) {
                tool = new Restore();
            } else if ("Recover".equals(string)) {
                tool = new Recover();
            } else if ("DeleteDbFiles".equals(string)) {
                tool = new DeleteDbFiles();
            } else if ("ChangeFileEncryption".equals(string)) {
                tool = new ChangeFileEncryption();
            } else if ("Script".equals(string)) {
                tool = new Script();
            } else if ("RunScript".equals(string)) {
                tool = new RunScript();
            } else if ("ConvertTraceFile".equals(string)) {
                tool = new ConvertTraceFile();
            } else if ("CreateCluster".equals(string)) {
                tool = new CreateCluster();
            } else {
                throw Message.throwInternalError(string);
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            PrintStream printStream = new PrintStream((OutputStream)byteArrayOutputStream, false, "UTF-8");
            tool.setOut(printStream);
            try {
                tool.run(stringArray);
                printStream.flush();
                String string3 = new String(byteArrayOutputStream.toByteArray(), "UTF-8");
                String string4 = PageParser.escapeHtml(string3);
                this.session.put("toolResult", string4);
            }
            catch (Exception exception) {
                this.session.put("toolResult", this.getStackTrace(0, exception, true));
            }
        }
        catch (Exception exception) {
            this.server.traceError(exception);
        }
        return "tools.jsp";
    }

    private String adminStartTranslate() {
        Map map = (Map)this.session.map.get("text");
        String string = this.server.startTranslate(map);
        this.session.put("translationFile", string);
        return "helpTranslate.jsp";
    }

    protected String adminShutdown() {
        this.server.shutdown();
        return "admin.jsp";
    }

    private String index() {
        String[][] stringArray = this.server.getLanguageArray();
        String string = (String)this.attributes.get("language");
        Locale locale = this.session.locale;
        if (string != null) {
            if (locale == null || !StringUtils.toLowerEnglish(locale.getLanguage()).equals(string)) {
                locale = new Locale(string, "");
                this.server.readTranslations(this.session, locale.getLanguage());
                this.session.put("language", string);
                this.session.locale = locale;
            }
        } else {
            string = (String)this.session.get("language");
        }
        if (string == null) {
            string = this.headerLanguage;
        }
        this.session.put("languageCombo", this.getComboBox(stringArray, string));
        String[] stringArray2 = this.server.getSettingNames();
        String string2 = this.attributes.getProperty("setting");
        if (string2 == null && stringArray2.length > 0) {
            string2 = stringArray2[0];
        }
        String string3 = this.getComboBox(stringArray2, string2);
        this.session.put("settingsList", string3);
        ConnectionInfo connectionInfo = this.server.getSetting(string2);
        if (connectionInfo == null) {
            connectionInfo = new ConnectionInfo();
        }
        this.session.put("setting", PageParser.escapeHtmlData(string2));
        this.session.put("name", PageParser.escapeHtmlData(string2));
        this.session.put("driver", PageParser.escapeHtmlData(connectionInfo.driver));
        this.session.put("url", PageParser.escapeHtmlData(connectionInfo.url));
        this.session.put("user", PageParser.escapeHtmlData(connectionInfo.user));
        return "index.jsp";
    }

    private String getHistory() {
        int n = Integer.parseInt(this.attributes.getProperty("id"));
        String string = this.session.getCommand(n);
        this.session.put("query", PageParser.escapeHtmlData(string));
        return "query.jsp";
    }

    private int addColumns(boolean bl, DbTableOrView dbTableOrView, StringBuilder stringBuilder, int n, boolean bl2, StringBuilder stringBuilder2) {
        DbColumn[] dbColumnArray = dbTableOrView.columns;
        for (int i = 0; dbColumnArray != null && i < dbColumnArray.length; ++i) {
            DbColumn dbColumn = dbColumnArray[i];
            if (stringBuilder2.length() > 0) {
                stringBuilder2.append(' ');
            }
            stringBuilder2.append(dbColumn.name);
            String string = StringUtils.urlEncode(PageParser.escapeJavaScript(dbColumn.name));
            String string2 = bl ? ", 1, 1" : ", 2, 2";
            stringBuilder.append("setNode(" + n + string2 + ", 'column', '" + PageParser.escapeJavaScript(dbColumn.name) + "', 'javascript:ins(\\'" + string + "\\')');\n");
            ++n;
            if (!bl || !bl2) continue;
            stringBuilder.append("setNode(" + n + ", 2, 2, 'type', '" + PageParser.escapeJavaScript(dbColumn.dataType) + "', null);\n");
            ++n;
        }
        return n;
    }

    private int addIndexes(boolean bl, DatabaseMetaData databaseMetaData, String string, String string2, StringBuilder stringBuilder, int n) throws SQLException {
        Object object;
        String string3;
        ResultSet resultSet = databaseMetaData.getIndexInfo(null, string2, string, false, true);
        HashMap<String, Object> hashMap = New.hashMap();
        while (resultSet.next()) {
            string3 = resultSet.getString("INDEX_NAME");
            object = (IndexInfo)hashMap.get(string3);
            if (object == null) {
                int n2 = resultSet.getInt("TYPE");
                Object object2 = n2 == 1 ? "" : (n2 == 2 ? " (${text.tree.hashed})" : (n2 == 3 ? "" : null));
                if (string3 == null || object2 == null) continue;
                object = new IndexInfo();
                ((IndexInfo)object).name = string3;
                ((IndexInfo)object).type = object2 = (resultSet.getBoolean("NON_UNIQUE") ? "${text.tree.nonUnique}" : "${text.tree.unique}") + (String)object2;
                ((IndexInfo)object).columns = resultSet.getString("COLUMN_NAME");
                hashMap.put(string3, object);
                continue;
            }
            ((IndexInfo)object).columns = ((IndexInfo)object).columns + ", " + resultSet.getString("COLUMN_NAME");
        }
        resultSet.close();
        if (hashMap.size() > 0) {
            string3 = bl ? ", 1, 1" : ", 2, 1";
            object = bl ? ", 2, 1" : ", 3, 1";
            String string4 = bl ? ", 3, 2" : ", 4, 2";
            stringBuilder.append("setNode(" + n + string3 + ", 'index_az', '${text.tree.indexes}', null);\n");
            ++n;
            for (IndexInfo indexInfo : hashMap.values()) {
                stringBuilder.append("setNode(" + n + (String)object + ", 'index', '" + PageParser.escapeJavaScript(indexInfo.name) + "', null);\n");
                stringBuilder.append("setNode(" + ++n + string4 + ", 'type', '" + indexInfo.type + "', null);\n");
                stringBuilder.append("setNode(" + ++n + string4 + ", 'type', '" + PageParser.escapeJavaScript(indexInfo.columns) + "', null);\n");
                ++n;
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int addTablesAndViews(DbSchema dbSchema, boolean bl, StringBuilder stringBuilder, int n) throws SQLException {
        StringBuilder stringBuilder2;
        String string;
        int n2;
        if (dbSchema == null) {
            return n;
        }
        Connection connection = this.session.getConnection();
        DatabaseMetaData databaseMetaData = this.session.getMetaData();
        int n3 = bl ? 0 : 1;
        boolean bl2 = bl || !dbSchema.isSystem;
        String string2 = ", " + n3 + ", " + (bl2 ? "1" : "2") + ", ";
        String string3 = ", " + (n3 + 1) + ", 2, ";
        DbTableOrView[] dbTableOrViewArray = dbSchema.tables;
        if (dbTableOrViewArray == null) {
            return n;
        }
        boolean bl3 = dbSchema.contents.isOracle;
        boolean bl4 = dbTableOrViewArray.length < 100;
        for (DbTableOrView dbTableOrView : dbTableOrViewArray) {
            if (dbTableOrView.isView) continue;
            n2 = n;
            string = dbTableOrView.quotedName;
            if (!bl) {
                string = dbSchema.quotedName + "." + string;
            }
            string = StringUtils.urlEncode(PageParser.escapeJavaScript(string));
            stringBuilder.append("setNode(" + n + string2 + " 'table', '" + PageParser.escapeJavaScript(dbTableOrView.name) + "', 'javascript:ins(\\'" + string + "\\',true)');\n");
            ++n;
            if (!bl && !bl2) continue;
            stringBuilder2 = new StringBuilder();
            n = this.addColumns(bl, dbTableOrView, stringBuilder, n, bl4, stringBuilder2);
            if (!bl3 && bl4) {
                n = this.addIndexes(bl, databaseMetaData, dbTableOrView.name, dbSchema.name, stringBuilder, n);
            }
            stringBuilder.append("addTable('" + PageParser.escapeJavaScript(dbTableOrView.name) + "', '" + PageParser.escapeJavaScript(stringBuilder2.toString()) + "', " + n2 + ");\n");
        }
        for (DbTableOrView dbTableOrView : dbTableOrViewArray = dbSchema.tables) {
            if (!dbTableOrView.isView) continue;
            n2 = n;
            string = dbTableOrView.quotedName;
            if (!bl) {
                string = dbTableOrView.schema.quotedName + "." + string;
            }
            string = StringUtils.urlEncode(PageParser.escapeJavaScript(string));
            stringBuilder.append("setNode(" + n + string2 + " 'view', '" + PageParser.escapeJavaScript(dbTableOrView.name) + "', 'javascript:ins(\\'" + string + "\\',true)');\n");
            ++n;
            if (!bl) continue;
            stringBuilder2 = new StringBuilder();
            n = this.addColumns(bl, dbTableOrView, stringBuilder, n, bl4, stringBuilder2);
            if (dbSchema.contents.isH2) {
                PreparedStatement preparedStatement = null;
                try {
                    preparedStatement = connection.prepareStatement("SELECT * FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_NAME=?");
                    preparedStatement.setString(1, dbTableOrView.name);
                    ResultSet resultSet = preparedStatement.executeQuery();
                    if (resultSet.next()) {
                        String string4 = resultSet.getString("SQL");
                        stringBuilder.append("setNode(" + n + string3 + " 'type', '" + PageParser.escapeJavaScript(string4) + "', null);\n");
                        ++n;
                    }
                    resultSet.close();
                }
                finally {
                    JdbcUtils.closeSilently(preparedStatement);
                }
            }
            stringBuilder.append("addTable('" + PageParser.escapeJavaScript(dbTableOrView.name) + "', '" + PageParser.escapeJavaScript(stringBuilder2.toString()) + "', " + n2 + ");\n");
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String tables() {
        DbContents dbContents = this.session.getContents();
        boolean bl = false;
        try {
            Object object;
            dbContents.readContents(this.session.getMetaData());
            this.session.loadBnf();
            Connection connection = this.session.getConnection();
            DatabaseMetaData databaseMetaData = this.session.getMetaData();
            bl = dbContents.isH2;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("setNode(0, 0, 0, 'database', '" + PageParser.escapeJavaScript((String)this.session.get("url")) + "', null);\n");
            int n = 1;
            DbSchema dbSchema = dbContents.defaultSchema;
            n = this.addTablesAndViews(dbSchema, true, stringBuilder, n);
            DbSchema[] dbSchemaArray = dbContents.schemas;
            for (DbSchema object2 : dbSchemaArray) {
                if (object2 == dbSchema || object2 == null) continue;
                stringBuilder.append("setNode(" + n + ", 0, 1, 'folder', '" + PageParser.escapeJavaScript(object2.name) + "', null);\n");
                ++n;
                n = this.addTablesAndViews(object2, false, stringBuilder, n);
            }
            if (bl) {
                object = null;
                try {
                    String string;
                    object = connection.createStatement();
                    ResultSet resultSet = object.executeQuery("SELECT * FROM INFORMATION_SCHEMA.SEQUENCES ORDER BY SEQUENCE_NAME");
                    int n2 = 0;
                    while (resultSet.next()) {
                        if (n2 == 0) {
                            stringBuilder.append("setNode(" + n + ", 0, 1, 'sequences', '${text.tree.sequences}', null);\n");
                            ++n;
                        }
                        String string2 = resultSet.getString("SEQUENCE_NAME");
                        string = resultSet.getString("CURRENT_VALUE");
                        String string3 = resultSet.getString("INCREMENT");
                        stringBuilder.append("setNode(" + n + ", 1, 1, 'sequence', '" + PageParser.escapeJavaScript(string2) + "', null);\n");
                        stringBuilder.append("setNode(" + ++n + ", 2, 2, 'type', '${text.tree.current}: " + PageParser.escapeJavaScript(string) + "', null);\n");
                        ++n;
                        if (!"1".equals(string3)) {
                            stringBuilder.append("setNode(" + n + ", 2, 2, 'type', '${text.tree.increment}: " + PageParser.escapeJavaScript(string3) + "', null);\n");
                            ++n;
                        }
                        ++n2;
                    }
                    resultSet.close();
                    resultSet = object.executeQuery("SELECT * FROM INFORMATION_SCHEMA.USERS ORDER BY NAME");
                    n2 = 0;
                    while (resultSet.next()) {
                        if (n2 == 0) {
                            stringBuilder.append("setNode(" + n + ", 0, 1, 'users', '${text.tree.users}', null);\n");
                            ++n;
                        }
                        String string4 = resultSet.getString("NAME");
                        string = resultSet.getString("ADMIN");
                        stringBuilder.append("setNode(" + n + ", 1, 1, 'user', '" + PageParser.escapeJavaScript(string4) + "', null);\n");
                        ++n;
                        if (string.equalsIgnoreCase("TRUE")) {
                            stringBuilder.append("setNode(" + n + ", 2, 2, 'type', '${text.tree.admin}', null);\n");
                            ++n;
                        }
                        ++n2;
                    }
                    resultSet.close();
                }
                finally {
                    JdbcUtils.closeSilently((Statement)object);
                }
            }
            object = databaseMetaData.getDatabaseProductName() + " " + databaseMetaData.getDatabaseProductVersion();
            stringBuilder.append("setNode(" + n + ", 0, 0, 'info', '" + PageParser.escapeJavaScript((String)object) + "', null);\n");
            stringBuilder.append("refreshQueryTables();");
            this.session.put("tree", stringBuilder.toString());
        }
        catch (Exception exception) {
            this.session.put("tree", "");
            this.session.put("error", this.getStackTrace(0, exception, bl));
        }
        return "tables.jsp";
    }

    private String getStackTrace(int n, Throwable throwable, boolean bl) {
        try {
            StringWriter stringWriter = new StringWriter();
            throwable.printStackTrace(new PrintWriter(stringWriter));
            String string = stringWriter.toString();
            string = PageParser.escapeHtml(string);
            if (bl) {
                string = this.linkToSource(string);
            }
            string = StringUtils.replaceAll(string, "\t", "&nbsp;&nbsp;&nbsp;&nbsp;");
            String string2 = PageParser.escapeHtml(throwable.getMessage());
            String string3 = "<a class=\"error\" href=\"#\" onclick=\"var x=document.getElementById('st" + n + "').style;x.display=x.display==''?'none':'';\">" + string2 + "</a>";
            if (throwable instanceof SQLException) {
                SQLException sQLException = (SQLException)throwable;
                string3 = string3 + " " + sQLException.getSQLState() + "/" + sQLException.getErrorCode();
                if (bl) {
                    int n2 = sQLException.getErrorCode();
                    string3 = string3 + " <a href=\"http://h2database.com/javadoc/org/h2/constant/ErrorCode.html#c" + n2 + "\">(${text.a.help})</a>";
                }
            }
            string3 = string3 + "<span style=\"display: none;\" id=\"st" + n + "\"><br />" + string + "</span>";
            string3 = this.formatAsError(string3);
            return string3;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            this.server.traceError(throwable);
            return throwable.toString();
        }
    }

    private String linkToSource(String string) {
        try {
            StringBuilder stringBuilder = new StringBuilder(string.length());
            int n = string.indexOf("<br />");
            stringBuilder.append(string.substring(0, n));
            while (true) {
                int n2;
                if ((n2 = string.indexOf("org.h2.", n)) < 0) {
                    stringBuilder.append(string.substring(n));
                    break;
                }
                stringBuilder.append(string.substring(n, n2));
                int n3 = string.indexOf(41, n2);
                if (n3 < 0) {
                    stringBuilder.append(string.substring(n));
                    break;
                }
                String string2 = string.substring(n2, n3);
                int n4 = string2.lastIndexOf(40);
                int n5 = string2.lastIndexOf(46, n4 - 1);
                int n6 = string2.lastIndexOf(46, n5 - 1);
                String string3 = string2.substring(0, n6);
                int n7 = string2.lastIndexOf(58);
                String string4 = string2.substring(n4 + 1, n7);
                String string5 = string2.substring(n7 + 1, string2.length());
                String string6 = string3.replace('.', '/') + "/" + string4;
                stringBuilder.append("<a href=\"http://h2database.com/html/source.html?file=");
                stringBuilder.append(string6);
                stringBuilder.append("&line=");
                stringBuilder.append(string5);
                stringBuilder.append("&build=");
                stringBuilder.append(128);
                stringBuilder.append("\">");
                stringBuilder.append(string2);
                stringBuilder.append("</a>");
                n = n3;
            }
            return stringBuilder.toString();
        }
        catch (Throwable throwable) {
            return string;
        }
    }

    private String formatAsError(String string) {
        return "<div class=\"error\">" + string + "</div>";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String test() {
        String string = this.attributes.getProperty("driver", "");
        String string2 = this.attributes.getProperty("url", "");
        String string3 = this.attributes.getProperty("user", "");
        String string4 = this.attributes.getProperty("password", "");
        this.session.put("driver", string);
        this.session.put("url", string2);
        this.session.put("user", string3);
        boolean bl = string2.startsWith("jdbc:h2:");
        try {
            Connection connection;
            long l = System.currentTimeMillis();
            String string5 = "";
            String string6 = "";
            Profiler profiler = new Profiler();
            profiler.startCollecting();
            try {
                connection = this.server.getConnection(string, string2, string3, string4, this);
            }
            finally {
                profiler.stopCollecting();
                string5 = profiler.getTop(3);
            }
            profiler = new Profiler();
            profiler.startCollecting();
            try {
                JdbcUtils.closeSilently(connection);
            }
            finally {
                profiler.stopCollecting();
                string6 = profiler.getTop(3);
            }
            long l2 = System.currentTimeMillis() - l;
            String string7 = l2 > 1000L ? "<a class=\"error\" href=\"#\" onclick=\"var x=document.getElementById('prof').style;x.display=x.display==''?'none':'';\">${text.login.testSuccessful}</a><span style=\"display: none;\" id=\"prof\"><br />" + PageParser.escapeHtml(string5) + "<br />" + PageParser.escapeHtml(string6) + "</span>" : "${text.login.testSuccessful}";
            this.session.put("error", string7);
            return "login.jsp";
        }
        catch (Exception exception) {
            this.session.put("error", this.getLoginError(exception, bl));
            return "login.jsp";
        }
    }

    String getLoginError(Exception exception, boolean bl) {
        if (exception instanceof JdbcSQLException && ((JdbcSQLException)exception).getErrorCode() == 90086) {
            return "${text.login.driverNotFound}<br />" + this.getStackTrace(0, exception, bl);
        }
        return this.getStackTrace(0, exception, bl);
    }

    private String login() {
        String string = this.attributes.getProperty("driver", "");
        String string2 = this.attributes.getProperty("url", "");
        String string3 = this.attributes.getProperty("user", "");
        String string4 = this.attributes.getProperty("password", "");
        this.session.put("autoCommit", "checked");
        this.session.put("autoComplete", "1");
        this.session.put("maxrows", "1000");
        if (this.loginAsync(string, string2, string3, string4)) {
            return "";
        }
        boolean bl = string2.startsWith("jdbc:h2:");
        try {
            Connection connection = this.server.getConnection(string, string2, string3, string4, this);
            this.session.setConnection(connection);
            this.session.put("url", string2);
            this.session.put("user", string3);
            this.session.remove("error");
            this.settingSave();
            return "frame.jsp";
        }
        catch (Exception exception) {
            this.session.put("error", this.getLoginError(exception, bl));
            return "login.jsp";
        }
    }

    protected boolean loginAsync(String string, String string2, String string3, String string4) {
        return false;
    }

    private String logout() {
        try {
            Connection connection = this.session.getConnection();
            this.session.setConnection(null);
            this.session.remove("conn");
            this.session.remove("result");
            this.session.remove("tables");
            this.session.remove("user");
            this.session.remove("tool");
            if (connection != null) {
                if (this.session.getShutdownServerOnDisconnect()) {
                    this.server.shutdown();
                } else {
                    connection.close();
                }
            }
        }
        catch (Exception exception) {
            this.trace(exception.toString());
        }
        return "index.do";
    }

    private String query() {
        String string = this.attributes.getProperty("sql").trim();
        try {
            String string2;
            Connection connection = this.session.getConnection();
            if ("@AUTOCOMMIT TRUE".equals(string)) {
                connection.setAutoCommit(true);
                string2 = "${text.result.autoCommitOn}";
            } else if ("@AUTOCOMMIT FALSE".equals(string)) {
                connection.setAutoCommit(false);
                string2 = "${text.result.autoCommitOff}";
            } else if (string.startsWith("@TRANSACTION_ISOLATION")) {
                String string3 = string.substring("@TRANSACTION_ISOLATION".length()).trim();
                if (string3.length() > 0) {
                    int n = Integer.parseInt(string3);
                    connection.setTransactionIsolation(n);
                }
                string2 = "Transaction Isolation: " + connection.getTransactionIsolation() + "<br />";
                string2 = string2 + "1: READ_UNCOMMITTED<br />";
                string2 = string2 + "2: READ_COMMITTED<br />";
                string2 = string2 + "4: REPEATABLE_READ<br />";
                string2 = string2 + "8: SERIALIZABLE";
            } else if (string.startsWith("@SET MAXROWS ")) {
                int n = Integer.parseInt(string.substring("@SET MAXROWS ".length()));
                this.session.put("maxrows", "" + n);
                string2 = "${text.result.maxrowsSet}";
            } else {
                CharSequence charSequence;
                ScriptReader scriptReader = new ScriptReader(new StringReader(string));
                ObjectArray<String> objectArray = ObjectArray.newInstance();
                while ((charSequence = scriptReader.readStatement()) != null) {
                    objectArray.add((String)charSequence);
                }
                charSequence = new StringBuilder();
                for (int i = 0; i < objectArray.size(); ++i) {
                    String string4 = (String)objectArray.get(i);
                    if (!string4.startsWith("@")) {
                        ((StringBuilder)charSequence).append(PageParser.escapeHtml(string4 + ";")).append("<br />");
                    }
                    ((StringBuilder)charSequence).append(this.getResult(connection, i + 1, string4, objectArray.size() == 1, false)).append("<br />");
                }
                string2 = ((StringBuilder)charSequence).toString();
            }
            this.session.put("result", string2);
        }
        catch (Throwable throwable) {
            this.session.put("result", this.getStackTrace(0, throwable, this.session.getContents().isH2));
        }
        return "result.jsp";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String editResult() {
        String string;
        String string2;
        block11: {
            ResultSet resultSet = this.session.result;
            int n = Integer.parseInt(this.attributes.getProperty("row"));
            int n2 = Integer.parseInt(this.attributes.getProperty("op"));
            string2 = "";
            string = "";
            try {
                if (n2 == 1) {
                    boolean bl;
                    boolean bl2 = bl = n < 0;
                    if (bl) {
                        resultSet.moveToInsertRow();
                    } else {
                        resultSet.absolute(n);
                    }
                    for (int i = 0; i < resultSet.getMetaData().getColumnCount(); ++i) {
                        String string3 = this.attributes.getProperty("r" + n + "c" + (i + 1));
                        this.unescapeData(string3, resultSet, i + 1);
                    }
                    if (bl) {
                        resultSet.insertRow();
                        break block11;
                    } else {
                        resultSet.updateRow();
                    }
                    break block11;
                }
                if (n2 == 2) {
                    resultSet.absolute(n);
                    resultSet.deleteRow();
                } else if (n2 != 3) {
                    // empty if block
                }
            }
            catch (Throwable throwable) {
                string2 = "<br />" + this.getStackTrace(0, throwable, this.session.getContents().isH2);
                string = this.formatAsError(throwable.getMessage());
            }
        }
        String string4 = "@EDIT " + (String)this.session.get("resultSetSQL");
        Connection connection = this.session.getConnection();
        string2 = string + this.getResult(connection, -1, string4, true, true) + string2;
        this.session.put("result", string2);
        return "result.jsp";
    }

    private ResultSet getMetaResultSet(Connection connection, String string) throws SQLException {
        DatabaseMetaData databaseMetaData = connection.getMetaData();
        if (string.startsWith("@TABLES")) {
            String[] stringArray = this.split(string);
            String[] stringArray2 = stringArray[4] == null ? null : StringUtils.arraySplit(stringArray[4], ',', false);
            return databaseMetaData.getTables(stringArray[1], stringArray[2], stringArray[3], stringArray2);
        }
        if (string.startsWith("@COLUMNS")) {
            String[] stringArray = this.split(string);
            return databaseMetaData.getColumns(stringArray[1], stringArray[2], stringArray[3], stringArray[4]);
        }
        if (string.startsWith("@INDEX_INFO")) {
            String[] stringArray = this.split(string);
            boolean bl = stringArray[4] == null ? false : Boolean.valueOf(stringArray[4]);
            boolean bl2 = stringArray[5] == null ? false : Boolean.valueOf(stringArray[5]);
            return databaseMetaData.getIndexInfo(stringArray[1], stringArray[2], stringArray[3], bl, bl2);
        }
        if (string.startsWith("@PRIMARY_KEYS")) {
            String[] stringArray = this.split(string);
            return databaseMetaData.getPrimaryKeys(stringArray[1], stringArray[2], stringArray[3]);
        }
        if (string.startsWith("@PROCEDURES")) {
            String[] stringArray = this.split(string);
            return databaseMetaData.getProcedures(stringArray[1], stringArray[2], stringArray[3]);
        }
        if (string.startsWith("@PROCEDURE_COLUMNS")) {
            String[] stringArray = this.split(string);
            return databaseMetaData.getProcedureColumns(stringArray[1], stringArray[2], stringArray[3], stringArray[4]);
        }
        if (string.startsWith("@SCHEMAS")) {
            return databaseMetaData.getSchemas();
        }
        if (string.startsWith("@CATALOG")) {
            SimpleResultSet simpleResultSet = new SimpleResultSet();
            simpleResultSet.addColumn("CATALOG", 12, 0, 0);
            simpleResultSet.addRow(connection.getCatalog());
            return simpleResultSet;
        }
        if (string.startsWith("@MEMORY")) {
            SimpleResultSet simpleResultSet = new SimpleResultSet();
            simpleResultSet.addColumn("Type", 12, 0, 0);
            simpleResultSet.addColumn("Value", 12, 0, 0);
            simpleResultSet.addRow("Used Memory", "" + MemoryUtils.getMemoryUsed());
            simpleResultSet.addRow("Free Memory", "" + MemoryUtils.getMemoryFree());
            return simpleResultSet;
        }
        if (string.startsWith("@INFO")) {
            String string2;
            SimpleResultSet simpleResultSet = new SimpleResultSet();
            simpleResultSet.addColumn("KEY", 12, 0, 0);
            simpleResultSet.addColumn("VALUE", 12, 0, 0);
            simpleResultSet.addRow("conn.getCatalog", connection.getCatalog());
            simpleResultSet.addRow("conn.getAutoCommit", "" + connection.getAutoCommit());
            simpleResultSet.addRow("conn.getTransactionIsolation", "" + connection.getTransactionIsolation());
            simpleResultSet.addRow("conn.getWarnings", "" + connection.getWarnings());
            try {
                string2 = "" + connection.getTypeMap();
            }
            catch (SQLException sQLException) {
                string2 = sQLException.toString();
            }
            simpleResultSet.addRow("conn.getTypeMap", "" + string2);
            simpleResultSet.addRow("conn.isReadOnly", "" + connection.isReadOnly());
            simpleResultSet.addRow("meta.getCatalogSeparator", "" + databaseMetaData.getCatalogSeparator());
            simpleResultSet.addRow("meta.getCatalogTerm", "" + databaseMetaData.getCatalogTerm());
            simpleResultSet.addRow("meta.getDatabaseProductName", "" + databaseMetaData.getDatabaseProductName());
            simpleResultSet.addRow("meta.getDatabaseProductVersion", "" + databaseMetaData.getDatabaseProductVersion());
            simpleResultSet.addRow("meta.getDefaultTransactionIsolation", "" + databaseMetaData.getDefaultTransactionIsolation());
            simpleResultSet.addRow("meta.getDriverMajorVersion", "" + databaseMetaData.getDriverMajorVersion());
            simpleResultSet.addRow("meta.getDriverMinorVersion", "" + databaseMetaData.getDriverMinorVersion());
            simpleResultSet.addRow("meta.getDriverName", "" + databaseMetaData.getDriverName());
            simpleResultSet.addRow("meta.getDriverVersion", "" + databaseMetaData.getDriverVersion());
            simpleResultSet.addRow("meta.getExtraNameCharacters", "" + databaseMetaData.getExtraNameCharacters());
            simpleResultSet.addRow("meta.getIdentifierQuoteString", "" + databaseMetaData.getIdentifierQuoteString());
            simpleResultSet.addRow("meta.getMaxBinaryLiteralLength", "" + databaseMetaData.getMaxBinaryLiteralLength());
            simpleResultSet.addRow("meta.getMaxCatalogNameLength", "" + databaseMetaData.getMaxCatalogNameLength());
            simpleResultSet.addRow("meta.getMaxCharLiteralLength", "" + databaseMetaData.getMaxCharLiteralLength());
            simpleResultSet.addRow("meta.getMaxColumnNameLength", "" + databaseMetaData.getMaxColumnNameLength());
            simpleResultSet.addRow("meta.getMaxColumnsInGroupBy", "" + databaseMetaData.getMaxColumnsInGroupBy());
            simpleResultSet.addRow("meta.getMaxColumnsInIndex", "" + databaseMetaData.getMaxColumnsInIndex());
            simpleResultSet.addRow("meta.getMaxColumnsInOrderBy", "" + databaseMetaData.getMaxColumnsInOrderBy());
            simpleResultSet.addRow("meta.getMaxColumnsInSelect", "" + databaseMetaData.getMaxColumnsInSelect());
            simpleResultSet.addRow("meta.getMaxColumnsInTable", "" + databaseMetaData.getMaxColumnsInTable());
            simpleResultSet.addRow("meta.getMaxConnections", "" + databaseMetaData.getMaxConnections());
            simpleResultSet.addRow("meta.getMaxCursorNameLength", "" + databaseMetaData.getMaxCursorNameLength());
            simpleResultSet.addRow("meta.getMaxIndexLength", "" + databaseMetaData.getMaxIndexLength());
            simpleResultSet.addRow("meta.getMaxProcedureNameLength", "" + databaseMetaData.getMaxProcedureNameLength());
            simpleResultSet.addRow("meta.getMaxRowSize", "" + databaseMetaData.getMaxRowSize());
            simpleResultSet.addRow("meta.getMaxSchemaNameLength", "" + databaseMetaData.getMaxSchemaNameLength());
            simpleResultSet.addRow("meta.getMaxStatementLength", "" + databaseMetaData.getMaxStatementLength());
            simpleResultSet.addRow("meta.getMaxStatements", "" + databaseMetaData.getMaxStatements());
            simpleResultSet.addRow("meta.getMaxTableNameLength", "" + databaseMetaData.getMaxTableNameLength());
            simpleResultSet.addRow("meta.getMaxTablesInSelect", "" + databaseMetaData.getMaxTablesInSelect());
            simpleResultSet.addRow("meta.getMaxUserNameLength", "" + databaseMetaData.getMaxUserNameLength());
            simpleResultSet.addRow("meta.getNumericFunctions", "" + databaseMetaData.getNumericFunctions());
            simpleResultSet.addRow("meta.getProcedureTerm", "" + databaseMetaData.getProcedureTerm());
            simpleResultSet.addRow("meta.getSchemaTerm", "" + databaseMetaData.getSchemaTerm());
            simpleResultSet.addRow("meta.getSearchStringEscape", "" + databaseMetaData.getSearchStringEscape());
            simpleResultSet.addRow("meta.getSQLKeywords", "" + databaseMetaData.getSQLKeywords());
            simpleResultSet.addRow("meta.getStringFunctions", "" + databaseMetaData.getStringFunctions());
            simpleResultSet.addRow("meta.getSystemFunctions", "" + databaseMetaData.getSystemFunctions());
            simpleResultSet.addRow("meta.getTimeDateFunctions", "" + databaseMetaData.getTimeDateFunctions());
            simpleResultSet.addRow("meta.getURL", "" + databaseMetaData.getURL());
            simpleResultSet.addRow("meta.getUserName", "" + databaseMetaData.getUserName());
            simpleResultSet.addRow("meta.isCatalogAtStart", "" + databaseMetaData.isCatalogAtStart());
            simpleResultSet.addRow("meta.isReadOnly", "" + databaseMetaData.isReadOnly());
            simpleResultSet.addRow("meta.allProceduresAreCallable", "" + databaseMetaData.allProceduresAreCallable());
            simpleResultSet.addRow("meta.allTablesAreSelectable", "" + databaseMetaData.allTablesAreSelectable());
            simpleResultSet.addRow("meta.dataDefinitionCausesTransactionCommit", "" + databaseMetaData.dataDefinitionCausesTransactionCommit());
            simpleResultSet.addRow("meta.dataDefinitionIgnoredInTransactions", "" + databaseMetaData.dataDefinitionIgnoredInTransactions());
            simpleResultSet.addRow("meta.doesMaxRowSizeIncludeBlobs", "" + databaseMetaData.doesMaxRowSizeIncludeBlobs());
            simpleResultSet.addRow("meta.nullPlusNonNullIsNull", "" + databaseMetaData.nullPlusNonNullIsNull());
            simpleResultSet.addRow("meta.nullsAreSortedAtEnd", "" + databaseMetaData.nullsAreSortedAtEnd());
            simpleResultSet.addRow("meta.nullsAreSortedAtStart", "" + databaseMetaData.nullsAreSortedAtStart());
            simpleResultSet.addRow("meta.nullsAreSortedHigh", "" + databaseMetaData.nullsAreSortedHigh());
            simpleResultSet.addRow("meta.nullsAreSortedLow", "" + databaseMetaData.nullsAreSortedLow());
            simpleResultSet.addRow("meta.storesLowerCaseIdentifiers", "" + databaseMetaData.storesLowerCaseIdentifiers());
            simpleResultSet.addRow("meta.storesLowerCaseQuotedIdentifiers", "" + databaseMetaData.storesLowerCaseQuotedIdentifiers());
            simpleResultSet.addRow("meta.storesMixedCaseIdentifiers", "" + databaseMetaData.storesMixedCaseIdentifiers());
            simpleResultSet.addRow("meta.storesMixedCaseQuotedIdentifiers", "" + databaseMetaData.storesMixedCaseQuotedIdentifiers());
            simpleResultSet.addRow("meta.storesUpperCaseIdentifiers", "" + databaseMetaData.storesUpperCaseIdentifiers());
            simpleResultSet.addRow("meta.storesUpperCaseQuotedIdentifiers", "" + databaseMetaData.storesUpperCaseQuotedIdentifiers());
            simpleResultSet.addRow("meta.supportsAlterTableWithAddColumn", "" + databaseMetaData.supportsAlterTableWithAddColumn());
            simpleResultSet.addRow("meta.supportsAlterTableWithDropColumn", "" + databaseMetaData.supportsAlterTableWithDropColumn());
            simpleResultSet.addRow("meta.supportsANSI92EntryLevelSQL", "" + databaseMetaData.supportsANSI92EntryLevelSQL());
            simpleResultSet.addRow("meta.supportsANSI92FullSQL", "" + databaseMetaData.supportsANSI92FullSQL());
            simpleResultSet.addRow("meta.supportsANSI92IntermediateSQL", "" + databaseMetaData.supportsANSI92IntermediateSQL());
            simpleResultSet.addRow("meta.supportsBatchUpdates", "" + databaseMetaData.supportsBatchUpdates());
            simpleResultSet.addRow("meta.supportsCatalogsInDataManipulation", "" + databaseMetaData.supportsCatalogsInDataManipulation());
            simpleResultSet.addRow("meta.supportsCatalogsInIndexDefinitions", "" + databaseMetaData.supportsCatalogsInIndexDefinitions());
            simpleResultSet.addRow("meta.supportsCatalogsInPrivilegeDefinitions", "" + databaseMetaData.supportsCatalogsInPrivilegeDefinitions());
            simpleResultSet.addRow("meta.supportsCatalogsInProcedureCalls", "" + databaseMetaData.supportsCatalogsInProcedureCalls());
            simpleResultSet.addRow("meta.supportsCatalogsInTableDefinitions", "" + databaseMetaData.supportsCatalogsInTableDefinitions());
            simpleResultSet.addRow("meta.supportsColumnAliasing", "" + databaseMetaData.supportsColumnAliasing());
            simpleResultSet.addRow("meta.supportsConvert", "" + databaseMetaData.supportsConvert());
            simpleResultSet.addRow("meta.supportsCoreSQLGrammar", "" + databaseMetaData.supportsCoreSQLGrammar());
            simpleResultSet.addRow("meta.supportsCorrelatedSubqueries", "" + databaseMetaData.supportsCorrelatedSubqueries());
            simpleResultSet.addRow("meta.supportsDataDefinitionAndDataManipulationTransactions", "" + databaseMetaData.supportsDataDefinitionAndDataManipulationTransactions());
            simpleResultSet.addRow("meta.supportsDataManipulationTransactionsOnly", "" + databaseMetaData.supportsDataManipulationTransactionsOnly());
            simpleResultSet.addRow("meta.supportsDifferentTableCorrelationNames", "" + databaseMetaData.supportsDifferentTableCorrelationNames());
            simpleResultSet.addRow("meta.supportsExpressionsInOrderBy", "" + databaseMetaData.supportsExpressionsInOrderBy());
            simpleResultSet.addRow("meta.supportsExtendedSQLGrammar", "" + databaseMetaData.supportsExtendedSQLGrammar());
            simpleResultSet.addRow("meta.supportsFullOuterJoins", "" + databaseMetaData.supportsFullOuterJoins());
            simpleResultSet.addRow("meta.supportsGroupBy", "" + databaseMetaData.supportsGroupBy());
            simpleResultSet.addRow("meta.usesLocalFilePerTable", "" + databaseMetaData.usesLocalFilePerTable());
            simpleResultSet.addRow("meta.usesLocalFiles", "" + databaseMetaData.usesLocalFiles());
            simpleResultSet.addRow("conn.getHoldability", "" + connection.getHoldability());
            simpleResultSet.addRow("meta.getDatabaseMajorVersion", "" + databaseMetaData.getDatabaseMajorVersion());
            simpleResultSet.addRow("meta.getDatabaseMinorVersion", "" + databaseMetaData.getDatabaseMinorVersion());
            simpleResultSet.addRow("meta.getJDBCMajorVersion", "" + databaseMetaData.getJDBCMajorVersion());
            simpleResultSet.addRow("meta.getJDBCMinorVersion", "" + databaseMetaData.getJDBCMinorVersion());
            simpleResultSet.addRow("meta.getResultSetHoldability", "" + databaseMetaData.getResultSetHoldability());
            simpleResultSet.addRow("meta.getSQLStateType", "" + databaseMetaData.getSQLStateType());
            simpleResultSet.addRow("meta.supportsGetGeneratedKeys", "" + databaseMetaData.supportsGetGeneratedKeys());
            simpleResultSet.addRow("meta.locatorsUpdateCopy", "" + databaseMetaData.locatorsUpdateCopy());
            return simpleResultSet;
        }
        if (string.startsWith("@CATALOGS")) {
            return databaseMetaData.getCatalogs();
        }
        if (string.startsWith("@TABLE_TYPES")) {
            return databaseMetaData.getTableTypes();
        }
        if (string.startsWith("@COLUMN_PRIVILEGES")) {
            String[] stringArray = this.split(string);
            return databaseMetaData.getColumnPrivileges(stringArray[1], stringArray[2], stringArray[3], stringArray[4]);
        }
        if (string.startsWith("@TABLE_PRIVILEGES")) {
            String[] stringArray = this.split(string);
            return databaseMetaData.getTablePrivileges(stringArray[1], stringArray[2], stringArray[3]);
        }
        if (string.startsWith("@BEST_ROW_IDENTIFIER")) {
            String[] stringArray = this.split(string);
            int n = stringArray[4] == null ? 0 : Integer.parseInt(stringArray[4]);
            boolean bl = stringArray[5] == null ? false : Boolean.valueOf(stringArray[5]);
            return databaseMetaData.getBestRowIdentifier(stringArray[1], stringArray[2], stringArray[3], n, bl);
        }
        if (string.startsWith("@VERSION_COLUMNS")) {
            String[] stringArray = this.split(string);
            return databaseMetaData.getVersionColumns(stringArray[1], stringArray[2], stringArray[3]);
        }
        if (string.startsWith("@IMPORTED_KEYS")) {
            String[] stringArray = this.split(string);
            return databaseMetaData.getImportedKeys(stringArray[1], stringArray[2], stringArray[3]);
        }
        if (string.startsWith("@EXPORTED_KEYS")) {
            String[] stringArray = this.split(string);
            return databaseMetaData.getExportedKeys(stringArray[1], stringArray[2], stringArray[3]);
        }
        if (string.startsWith("@CROSS_REFERENCE")) {
            String[] stringArray = this.split(string);
            return databaseMetaData.getCrossReference(stringArray[1], stringArray[2], stringArray[3], stringArray[4], stringArray[5], stringArray[6]);
        }
        if (string.startsWith("@UDTS")) {
            int[] nArray;
            String[] stringArray = this.split(string);
            if (stringArray[4] == null) {
                nArray = null;
            } else {
                String[] stringArray3 = StringUtils.arraySplit(stringArray[4], ',', false);
                nArray = new int[stringArray3.length];
                for (int i = 0; i < stringArray3.length; ++i) {
                    nArray[i] = Integer.parseInt(stringArray3[i]);
                }
            }
            return databaseMetaData.getUDTs(stringArray[1], stringArray[2], stringArray[3], nArray);
        }
        if (string.startsWith("@TYPE_INFO")) {
            return databaseMetaData.getTypeInfo();
        }
        if (string.startsWith("@SUPER_TYPES")) {
            String[] stringArray = this.split(string);
            return databaseMetaData.getSuperTypes(stringArray[1], stringArray[2], stringArray[3]);
        }
        if (string.startsWith("@SUPER_TABLES")) {
            String[] stringArray = this.split(string);
            return databaseMetaData.getSuperTables(stringArray[1], stringArray[2], stringArray[3]);
        }
        if (string.startsWith("@ATTRIBUTES")) {
            String[] stringArray = this.split(string);
            return databaseMetaData.getAttributes(stringArray[1], stringArray[2], stringArray[3], stringArray[4]);
        }
        if (string.startsWith("@PROF_START")) {
            if (this.profiler != null) {
                this.profiler.stopCollecting();
            }
            this.profiler = new Profiler();
            this.profiler.startCollecting();
        } else if (string.startsWith("@PROF_STOP") && this.profiler != null) {
            this.profiler.stopCollecting();
            SimpleResultSet simpleResultSet = new SimpleResultSet();
            simpleResultSet.addColumn("Top Stack Trace(s)", 12, 0, 0);
            simpleResultSet.addRow(this.profiler.getTop(3));
            this.profiler = null;
            return simpleResultSet;
        }
        return null;
    }

    private String[] split(String string) {
        String[] stringArray = new String[10];
        String[] stringArray2 = StringUtils.arraySplit(string, ' ', true);
        System.arraycopy(stringArray2, 0, stringArray, 0, stringArray2.length);
        for (int i = 0; i < stringArray.length; ++i) {
            if (!"null".equals(stringArray[i])) continue;
            stringArray[i] = null;
        }
        return stringArray;
    }

    private int getMaxrows() {
        String string = (String)this.session.get("maxrows");
        int n = string == null ? 0 : Integer.parseInt(string);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getResult(Connection connection, int n, String string, boolean bl, boolean bl2) {
        String string2;
        try {
            ResultSet resultSet;
            Object object;
            string = string.trim();
            StringBuilder stringBuilder = new StringBuilder();
            string2 = StringUtils.toUpperEnglish(string);
            if (string2.indexOf("CREATE") >= 0 || string2.indexOf("DROP") >= 0 || string2.indexOf("ALTER") >= 0 || string2.indexOf("RUNSCRIPT") >= 0) {
                object = this.attributes.getProperty("jsessionid");
                stringBuilder.append("<script type=\"text/javascript\">top['h2menu'].location='tables.do?jsessionid=" + (String)object + "';</script>");
            }
            DbContents dbContents = this.session.getContents();
            object = bl2 || bl && dbContents.isH2 ? connection.createStatement(1004, 1008) : connection.createStatement();
            long l = System.currentTimeMillis();
            boolean bl3 = false;
            boolean bl4 = false;
            boolean bl5 = false;
            boolean bl6 = false;
            if ("@CANCEL".equals(string)) {
                object = this.session.executingStatement;
                if (object != null) {
                    object.cancel();
                    stringBuilder.append("${text.result.statementWasCanceled}");
                } else {
                    stringBuilder.append("${text.result.noRunningStatement}");
                }
                String string3 = stringBuilder.toString();
                return string3;
            }
            if (string.startsWith("@PARAMETER_META")) {
                string = string.substring("@PARAMETER_META".length()).trim();
                PreparedStatement preparedStatement = connection.prepareStatement(string);
                stringBuilder.append(this.getParameterResultSet(preparedStatement.getParameterMetaData()));
                String string4 = stringBuilder.toString();
                return string4;
            }
            if (string.startsWith("@META")) {
                bl3 = true;
                string = string.substring("@META".length()).trim();
            } else if (string.startsWith("@LIST")) {
                bl6 = true;
                string = string.substring("@LIST".length()).trim();
            } else if (string.startsWith("@GENERATED")) {
                bl4 = true;
                string = string.substring("@GENERATED".length()).trim();
            } else {
                if (string.startsWith("@LOOP")) {
                    string = string.substring("@LOOP".length()).trim();
                    int n2 = string.indexOf(32);
                    int n3 = MathUtils.decodeInt(string.substring(0, n2));
                    string = string.substring(n2).trim();
                    String string5 = this.executeLoop(connection, n3, string);
                    return string5;
                }
                if (string.startsWith("@EDIT")) {
                    bl5 = true;
                    string = string.substring("@EDIT".length()).trim();
                    this.session.put("resultSetSQL", string);
                } else if ("@HISTORY".equals(string)) {
                    stringBuilder.append(this.getHistoryString());
                    String string6 = stringBuilder.toString();
                    return string6;
                }
            }
            if (string.startsWith("@")) {
                resultSet = this.getMetaResultSet(connection, string);
                if (resultSet == null) {
                    stringBuilder.append("?: " + string);
                    String string7 = stringBuilder.toString();
                    return string7;
                }
            } else {
                int n4 = this.getMaxrows();
                object.setMaxRows(n4);
                this.session.executingStatement = object;
                boolean bl7 = object.execute(string);
                this.session.addCommand(string);
                if (bl4) {
                    resultSet = null;
                    resultSet = object.getGeneratedKeys();
                } else {
                    if (!bl7) {
                        stringBuilder.append("${text.result.updateCount}: " + object.getUpdateCount());
                        l = System.currentTimeMillis() - l;
                        stringBuilder.append("<br />(").append(l).append(" ms)");
                        object.close();
                        String string8 = stringBuilder.toString();
                        return string8;
                    }
                    resultSet = object.getResultSet();
                }
            }
            l = System.currentTimeMillis() - l;
            stringBuilder.append(this.getResultSet(string, resultSet, bl3, bl6, bl5, l, bl));
            if (!bl5) {
                object.close();
            }
            String string9 = stringBuilder.toString();
            return string9;
        }
        catch (Throwable throwable) {
            string2 = this.getStackTrace(n, throwable, this.session.getContents().isH2);
            return string2;
        }
        finally {
            this.session.executingStatement = null;
        }
    }

    private String executeLoop(Connection connection, int n, String string) throws SQLException {
        Object object;
        int n2;
        Object object2;
        boolean bl;
        ArrayList<Integer> arrayList = New.arrayList();
        int n3 = 0;
        while (!this.stop && (n3 = string.indexOf(63, n3)) >= 0) {
            if (string.substring(n3).startsWith("?/*RND*/")) {
                arrayList.add(1);
                string = string.substring(0, n3) + "?" + string.substring(n3 + "/*RND*/".length() + 1);
            } else {
                arrayList.add(0);
            }
            ++n3;
        }
        int n4 = 0;
        Random random = new Random(1L);
        long l = System.currentTimeMillis();
        if (string.startsWith("@STATEMENT")) {
            string = string.substring("@STATEMENT".length()).trim();
            bl = false;
            object2 = connection.createStatement();
            for (n2 = 0; !this.stop && n2 < n; ++n2) {
                String string2 = string;
                for (Integer n5 : arrayList) {
                    n3 = string2.indexOf(63);
                    if (n5 == 1) {
                        string2 = string2.substring(0, n3) + random.nextInt(n) + string2.substring(n3 + 1);
                        continue;
                    }
                    string2 = string2.substring(0, n3) + n2 + string2.substring(n3 + 1);
                }
                if (!object2.execute(string2)) continue;
                object = object2.getResultSet();
                while (!this.stop && object.next()) {
                    ++n4;
                }
                object.close();
            }
        } else {
            bl = true;
            object2 = connection.prepareStatement(string);
            for (n2 = 0; !this.stop && n2 < n; ++n2) {
                for (int i = 0; i < arrayList.size(); ++i) {
                    object = arrayList.get(i);
                    if ((Integer)object == 1) {
                        object2.setInt(i + 1, random.nextInt(n));
                        continue;
                    }
                    object2.setInt(i + 1, n2);
                }
                if (this.session.getContents().isSQLite) {
                    object2.executeUpdate();
                    continue;
                }
                if (!object2.execute()) continue;
                ResultSet resultSet = object2.getResultSet();
                while (!this.stop && resultSet.next()) {
                    ++n4;
                }
                resultSet.close();
            }
        }
        l = System.currentTimeMillis() - l;
        object2 = new StatementBuilder();
        ((StatementBuilder)object2).append(l).append(" ms: ").append(n).append(" * ");
        if (bl) {
            ((StatementBuilder)object2).append("(Prepared) ");
        } else {
            ((StatementBuilder)object2).append("(Statement) ");
        }
        ((StatementBuilder)object2).append('(');
        for (int n6 : arrayList) {
            ((StatementBuilder)object2).appendExceptFirst(", ");
            ((StatementBuilder)object2).append(n6 == 0 ? "i" : "rnd");
        }
        return ((StatementBuilder)object2).append(") ").append(string).toString();
    }

    private String getHistoryString() {
        StringBuilder stringBuilder = new StringBuilder();
        ArrayList<String> arrayList = this.session.getCommands();
        stringBuilder.append("<table cellspacing=0 cellpadding=0><tr><th></th><th>Command</th></tr>");
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            String string = arrayList.get(i);
            stringBuilder.append("<tr><td><a href=\"getHistory.do?id=").append(i).append("&jsessionid=${sessionId}\" target=\"h2query\" >").append("<img width=16 height=16 src=\"ico_write.gif\" onmouseover = \"this.className ='icon_hover'\" ").append("onmouseout = \"this.className ='icon'\" class=\"icon\" alt=\"${text.resultEdit.edit}\" ").append("title=\"${text.resultEdit.edit}\" border=\"1\"/></a>").append("</td><td>").append(PageParser.escapeHtml(string)).append("</td></tr>");
        }
        stringBuilder.append("</table>");
        return stringBuilder.toString();
    }

    private String getParameterResultSet(ParameterMetaData parameterMetaData) throws SQLException {
        StringBuilder stringBuilder = new StringBuilder();
        if (parameterMetaData == null) {
            return "No parameter meta data";
        }
        stringBuilder.append("<table cellspacing=0 cellpadding=0>").append("<tr><th>className</th><th>mode</th><th>type</th>").append("<th>typeName</th><th>precision</th><th>scale</th></tr>");
        for (int i = 0; i < parameterMetaData.getParameterCount(); ++i) {
            stringBuilder.append("</tr><td>").append(parameterMetaData.getParameterClassName(i + 1)).append("</td><td>").append(parameterMetaData.getParameterMode(i + 1)).append("</td><td>").append(parameterMetaData.getParameterType(i + 1)).append("</td><td>").append(parameterMetaData.getParameterTypeName(i + 1)).append("</td><td>").append(parameterMetaData.getPrecision(i + 1)).append("</td><td>").append(parameterMetaData.getScale(i + 1)).append("</td></tr>");
        }
        stringBuilder.append("</table>");
        return stringBuilder.toString();
    }

    private String getResultSet(String string, ResultSet resultSet, boolean bl, boolean bl2, boolean bl3, long l, boolean bl4) throws SQLException {
        int n;
        int n2 = this.getMaxrows();
        l = System.currentTimeMillis() - l;
        StringBuilder stringBuilder = new StringBuilder();
        if (bl3) {
            stringBuilder.append("<form id=\"editing\" name=\"editing\" method=\"post\" action=\"editResult.do?jsessionid=${sessionId}\" id=\"mainForm\" target=\"h2result\"><input type=\"hidden\" name=\"op\" value=\"1\" /><input type=\"hidden\" name=\"row\" value=\"\" /><table cellspacing=0 cellpadding=0 id=\"editTable\">");
        } else {
            stringBuilder.append("<table cellspacing=0 cellpadding=0>");
        }
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int n3 = resultSetMetaData.getColumnCount();
        int n4 = 0;
        if (bl) {
            stringBuilder.append("<tr><th>i</th><th>label</th><th>cat</th><th>schem</th><th>tab</th><th>col</th><th>type</th><th>typeName</th><th>class</th><th>prec</th><th>scale</th><th>size</th><th>autoInc</th><th>case</th><th>currency</th><th>null</th><th>ro</th><th>search</th><th>sig</th><th>w</th><th>defW</th></tr>");
            for (n = 1; n <= n3; ++n) {
                stringBuilder.append("<tr>").append("<td>").append(n).append("</td>").append("<td>").append(PageParser.escapeHtml(resultSetMetaData.getColumnLabel(n))).append("</td>").append("<td>").append(PageParser.escapeHtml(resultSetMetaData.getCatalogName(n))).append("</td>").append("<td>").append(PageParser.escapeHtml(resultSetMetaData.getSchemaName(n))).append("</td>").append("<td>").append(PageParser.escapeHtml(resultSetMetaData.getTableName(n))).append("</td>").append("<td>").append(PageParser.escapeHtml(resultSetMetaData.getColumnName(n))).append("</td>").append("<td>").append(resultSetMetaData.getColumnType(n)).append("</td>").append("<td>").append(PageParser.escapeHtml(resultSetMetaData.getColumnTypeName(n))).append("</td>").append("<td>").append(PageParser.escapeHtml(resultSetMetaData.getColumnClassName(n))).append("</td>").append("<td>").append(resultSetMetaData.getPrecision(n)).append("</td>").append("<td>").append(resultSetMetaData.getScale(n)).append("</td>").append("<td>").append(resultSetMetaData.getColumnDisplaySize(n)).append("</td>").append("<td>").append(resultSetMetaData.isAutoIncrement(n)).append("</td>").append("<td>").append(resultSetMetaData.isCaseSensitive(n)).append("</td>").append("<td>").append(resultSetMetaData.isCurrency(n)).append("</td>").append("<td>").append(resultSetMetaData.isNullable(n)).append("</td>").append("<td>").append(resultSetMetaData.isReadOnly(n)).append("</td>").append("<td>").append(resultSetMetaData.isSearchable(n)).append("</td>").append("<td>").append(resultSetMetaData.isSigned(n)).append("</td>").append("<td>").append(resultSetMetaData.isWritable(n)).append("</td>").append("<td>").append(resultSetMetaData.isDefinitelyWritable(n)).append("</td>").append("</tr>");
            }
        } else if (bl2) {
            stringBuilder.append("<tr><th>Column</th><th>Data</th></tr><tr>");
            while (resultSet.next() && (n2 <= 0 || n4 < n2)) {
                stringBuilder.append("<tr><td>Row #</td><td>").append(++n4).append("</tr>");
                for (n = 0; n < n3; ++n) {
                    stringBuilder.append("<tr><td>").append(PageParser.escapeHtml(resultSetMetaData.getColumnLabel(n + 1))).append("</td><td>").append(this.escapeData(resultSet, n + 1)).append("</td></tr>");
                }
            }
        } else {
            stringBuilder.append("<tr>");
            if (bl3) {
                stringBuilder.append("<th>Action</th>");
            }
            for (n = 0; n < n3; ++n) {
                stringBuilder.append("<th>").append(PageParser.escapeHtml(resultSetMetaData.getColumnLabel(n + 1))).append("</th>");
            }
            stringBuilder.append("</tr>");
            while (resultSet.next() && (n2 <= 0 || n4 < n2)) {
                ++n4;
                stringBuilder.append("<tr>");
                if (bl3) {
                    stringBuilder.append("<td>").append("<img onclick=\"javascript:editRow(").append(resultSet.getRow()).append(",'${sessionId}', '${text.resultEdit.save}', '${text.resultEdit.cancel}'").append(")\" width=16 height=16 src=\"ico_write.gif\" onmouseover = \"this.className ='icon_hover'\" onmouseout = \"this.className ='icon'\" class=\"icon\" alt=\"${text.resultEdit.edit}\" title=\"${text.resultEdit.edit}\" border=\"1\"/>").append("<a href=\"editResult.do?op=2&row=").append(resultSet.getRow()).append("&jsessionid=${sessionId}\" target=\"h2result\" ><img width=16 height=16 src=\"ico_remove.gif\" onmouseover = \"this.className ='icon_hover'\" onmouseout = \"this.className ='icon'\" class=\"icon\" alt=\"${text.resultEdit.delete}\" title=\"${text.resultEdit.delete}\" border=\"1\" /></a>").append("</td>");
                }
                for (n = 0; n < n3; ++n) {
                    stringBuilder.append("<td>").append(this.escapeData(resultSet, n + 1)).append("</td>");
                }
                stringBuilder.append("</tr>");
            }
        }
        n = 0;
        try {
            n = resultSet.getConcurrency() == 1008 && resultSet.getType() != 1003 ? 1 : 0;
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (bl3) {
            ResultSet resultSet2 = this.session.result;
            if (resultSet2 != null) {
                resultSet2.close();
            }
            this.session.result = resultSet;
        } else {
            resultSet.close();
        }
        if (bl3) {
            stringBuilder.append("<tr><td>").append("<img onclick=\"javascript:editRow(-1, '${sessionId}', '${text.resultEdit.save}', '${text.resultEdit.cancel}'").append(")\" width=16 height=16 src=\"ico_add.gif\" onmouseover = \"this.className ='icon_hover'\" onmouseout = \"this.className ='icon'\" class=\"icon\" alt=\"${text.resultEdit.add}\" title=\"${text.resultEdit.add}\" border=\"1\"/>").append("</td>");
            for (int i = 0; i < n3; ++i) {
                stringBuilder.append("<td></td>");
            }
            stringBuilder.append("</tr>");
        }
        stringBuilder.append("</table>");
        if (bl3) {
            stringBuilder.append("</form>");
        }
        if (n4 == 0) {
            stringBuilder.append("(${text.result.noRows}");
        } else if (n4 == 1) {
            stringBuilder.append("(${text.result.1row}");
        } else {
            stringBuilder.append('(').append(n4).append(" ${text.result.rows}");
        }
        stringBuilder.append(", ");
        l = System.currentTimeMillis() - l;
        stringBuilder.append(l).append(" ms)");
        if (!bl3 && n != 0 && bl4) {
            stringBuilder.append("<br /><br /><form name=\"editResult\" method=\"post\" action=\"query.do?jsessionid=${sessionId}\" target=\"h2result\"><input type=\"submit\" class=\"button\" value=\"${text.resultEdit.editResult}\" /><input type=\"hidden\" name=\"sql\" value=\"@EDIT ").append(PageParser.escapeHtml(string)).append("\" /></form>");
        }
        return stringBuilder.toString();
    }

    String settingSave() {
        ConnectionInfo connectionInfo = new ConnectionInfo();
        connectionInfo.name = this.attributes.getProperty("name", "");
        connectionInfo.driver = this.attributes.getProperty("driver", "");
        connectionInfo.url = this.attributes.getProperty("url", "");
        connectionInfo.user = this.attributes.getProperty("user", "");
        this.server.updateSetting(connectionInfo);
        this.attributes.put("setting", connectionInfo.name);
        this.server.saveSettings(null);
        return "index.do";
    }

    private String escapeData(ResultSet resultSet, int n) throws SQLException {
        String string = resultSet.getString(n);
        if (string == null) {
            return "<i>null</i>";
        }
        if (string.length() > SysProperties.WEB_MAX_VALUE_LENGTH) {
            String string2 = this.isBinary(resultSet.getMetaData().getColumnType(n)) ? PageParser.escapeHtml(string.substring(0, 6)) + "... (" + string.length() / 2 + " ${text.result.bytes})" : PageParser.escapeHtml(string.substring(0, 100)) + "... (" + string.length() + " ${text.result.characters})";
            return "<div style='display: none'>=+</div>" + string2;
        }
        if (string.equals("null") || string.startsWith("= ") || string.startsWith("=+")) {
            return "<div style='display: none'>= </div>" + PageParser.escapeHtml(string);
        }
        return PageParser.escapeHtml(string);
    }

    private boolean isBinary(int n) {
        switch (n) {
            case -4: 
            case -3: 
            case -2: 
            case 1111: 
            case 2000: 
            case 2004: {
                return true;
            }
        }
        return false;
    }

    private void unescapeData(String string, ResultSet resultSet, int n) throws SQLException {
        if (string.equals("null")) {
            resultSet.updateNull(n);
        } else if (!string.startsWith("=+")) {
            if (string.startsWith("= ")) {
                string = string.substring(2);
                resultSet.updateString(n, string);
            } else {
                resultSet.updateString(n, string);
            }
        }
    }

    private String settingRemove() {
        String string = this.attributes.getProperty("name", "");
        this.server.removeSetting(string);
        ArrayList<ConnectionInfo> arrayList = this.server.getSettings();
        if (arrayList.size() > 0) {
            this.attributes.put("setting", arrayList.get(0));
        }
        this.server.saveSettings(null);
        return "index.do";
    }

    String getMimeType() {
        return this.mimeType;
    }

    boolean getCache() {
        return this.cache;
    }

    WebSession getSession() {
        return this.session;
    }

    public void closingDatabase() {
        this.trace("Closing database");
    }

    public void diskSpaceIsLow(long l) {
        this.trace("No more disk space is available");
    }

    public void exceptionThrown(SQLException sQLException, String string) {
        this.trace("Exception: " + sQLException.toString() + " SQL: " + string);
    }

    public void init(String string) {
        this.trace("Init: " + string);
    }

    public void opened() {
        this.trace("Database was opened");
    }

    public void setProgress(int n, String string, int n2, int n3) {
        if (n == this.listenerLastState) {
            long l = System.currentTimeMillis();
            if (this.listenerLastEvent + 500L < l) {
                return;
            }
            this.listenerLastEvent = l;
        } else {
            this.listenerLastState = n;
        }
        switch (n) {
            case 3: {
                this.trace("Backing up " + string + " " + 100L * (long)n2 / (long)n3 + "%");
                break;
            }
            case 1: {
                this.trace("Creating index " + string + " " + 100L * (long)n2 / (long)n3 + "%");
                break;
            }
            case 2: {
                this.trace("Recovering " + string + " " + 100L * (long)n2 / (long)n3 + "%");
                break;
            }
            case 0: {
                this.trace("Scanning file " + string + " " + 100L * (long)n2 / (long)n3 + "%");
                break;
            }
            default: {
                this.trace("Unknown state: " + n);
            }
        }
    }

    private void trace(String string) {
        this.server.trace(string);
    }

    static class IndexInfo {
        String name;
        String type;
        String columns;

        IndexInfo() {
        }
    }
}

