/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io.compress.zlib;

import java.io.IOException;
import java.util.zip.Deflater;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.compress.Compressor;
import org.apache.hadoop.io.compress.zlib.ZlibCompressor;
import org.apache.hadoop.io.compress.zlib.ZlibFactory;
import org.mortbay.log.Log;

public class BuiltInZlibDeflater
extends Deflater
implements Compressor {
    public BuiltInZlibDeflater(int level, boolean nowrap) {
        super(level, nowrap);
    }

    public BuiltInZlibDeflater(int level) {
        super(level);
    }

    public BuiltInZlibDeflater() {
    }

    @Override
    public synchronized int compress(byte[] b, int off, int len) throws IOException {
        return super.deflate(b, off, len);
    }

    @Override
    public void reinit(Configuration conf) {
        this.reset();
        if (conf == null) {
            return;
        }
        this.setLevel(ZlibFactory.getCompressionLevel(conf).compressionLevel());
        ZlibCompressor.CompressionStrategy strategy = ZlibFactory.getCompressionStrategy(conf);
        try {
            this.setStrategy(strategy.compressionStrategy());
        }
        catch (IllegalArgumentException ill) {
            Log.warn((String)((Object)((Object)strategy) + " not supported by BuiltInZlibDeflater."));
            this.setStrategy(0);
        }
        Log.debug((String)"Reinit compressor with new compression configuration");
    }
}

