% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/step2_wo_netMHCpan.R
\name{step2_wo_netMHCpan}
\alias{step2_wo_netMHCpan}
\title{step2_wo_netMHCpan}
\usage{
step2_wo_netMHCpan(
  peptide_rerun,
  HF_step1_output,
  export_files = FALSE,
  export_dir = NULL
)
}
\arguments{
\item{peptide_rerun}{dataframe containing the results of the second database
PEAKS search.}

\item{HF_step1_output}{the HybridFinder output containing the potential
splicing categorizations obtained with the HybridFinder function (HybridFinder)
based on the matching of fragment pairs of peptides in 1 or 2 proteins. This
parameter can be provided either by loading the .csv exported file, or if the
results #' object still is in the global environment (i.e results_HF_Exp1),
then it can be accessed by simply writing "results_HF_Exp1[[1]]".}

\item{export_files}{a boolean parameter for exporting the dataframes into
files in the next parameter for the output directory, Default: FALSE}

\item{export_dir}{export_dir the output directory for the results files
if export_files=TRUE, Default: NULL}
}
\value{
\enumerate{
    \item the input file for the web version of netMHCpan (dataframe)
    \item the database search rerun with the categorizations already determined
    in the previous step. (character vector)}
}
\description{
This function helps retrieve the categorizations for the peptides
from step 1 and apply them to those that are matched in the second database
search.
}
\details{
In special cases where the PC runs on windows OS, since it would only
be possible to use the web version of netMHCpan, this function returns the
peptide input file for the webversion of netMHCpan. Also, this function outputs
the database search rerun results with their categorizations (into potentially
cis and potentially trans) obtained from the first step (HybridFinder).
}
\examples{
\donttest{
results_checknetmhcpan_Exp1<- step2_wo_netMHCpan(peptide_rerun, Exp1_HF_results[[1]])
results_checknetmhcpan_Exp1 <- step2_wo_netMHCpan(peptide_rerun, Exp1_HF_results_denovo_w_spliced)
}
}
