/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.io.SaveDialog;
import ij.plugin.PlugIn;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;

public class FITS_Writer
implements PlugIn {
    public void run(String string) {
        Object object;
        Object object2;
        ImagePlus imagePlus = IJ.getImage();
        ImageProcessor imageProcessor = imagePlus.getProcessor();
        int n = imagePlus.getImageStackSize();
        int n2 = imagePlus.getBitDepth();
        if (n2 == 24) {
            IJ.error("RGB images are not supported");
            return;
        }
        if (string == null || string.trim().length() == 0) {
            object2 = "image.fits";
            object = new SaveDialog("Write FITS image", (String)object2, ".fits");
            string = ((SaveDialog)object).getDirectory() + ((SaveDialog)object).getFileName();
        }
        object2 = new File(string);
        object = ((File)object2).getParent() + File.separator;
        String string2 = ((File)object2).getName();
        if (((File)object2).exists()) {
            ((File)object2).delete();
        }
        int n3 = 0;
        if (n2 == 8) {
            imageProcessor = imageProcessor.convertToShort(false);
        } else if (imagePlus.getCalibration().isSigned16Bit()) {
            imageProcessor = imageProcessor.convertToFloat();
        }
        if (imageProcessor instanceof ShortProcessor) {
            n3 = 2;
        } else if (imageProcessor instanceof FloatProcessor) {
            n3 = 4;
        }
        int n4 = 2880 - n3 * imagePlus.getWidth() * imagePlus.getHeight() % 2880;
        String[] stringArray = FITS_Writer.getHeader(imagePlus);
        if (stringArray == null) {
            this.createHeader(string, imageProcessor, n3);
        } else {
            this.copyHeader(stringArray, string, imageProcessor, n3);
        }
        this.writeData(string, imageProcessor);
        char[] cArray = new char[n4];
        this.appendFile(cArray, string);
    }

    void createHeader(String string, ImageProcessor imageProcessor, int n) {
        int n2 = 5;
        String string2 = "";
        if (n == 2) {
            string2 = "                  16";
        } else if (n == 4) {
            string2 = "                 -32";
        } else if (n == 1) {
            string2 = "                   8";
        }
        this.appendFile(this.writeCard("SIMPLE", "                   T", "Created by ImageJ FITS_Writer 2008-09-07"), string);
        this.appendFile(this.writeCard("BITPIX", string2, ""), string);
        this.appendFile(this.writeCard("NAXIS", "                   2", ""), string);
        this.appendFile(this.writeCard("NAXIS1", "                 " + imageProcessor.getWidth(), "image width"), string);
        this.appendFile(this.writeCard("NAXIS2", "                 " + imageProcessor.getHeight(), "image height"), string);
        int n3 = 2880 - (n2 * 80 + 3) % 2880;
        char[] cArray = new char[]{'E', 'N', 'D'};
        char[] cArray2 = new char[n3];
        for (int i = 0; i < n3; ++i) {
            cArray2[i] = 32;
        }
        this.appendFile(cArray, string);
        this.appendFile(cArray2, string);
    }

    char[] writeCard(String string, String string2, String string3) {
        char[] cArray = new char[80];
        for (int i = 0; i < 80; ++i) {
            cArray[i] = 32;
        }
        this.s2ch(string, cArray, 0);
        cArray[8] = 61;
        this.s2ch(string2, cArray, 10);
        cArray[31] = 47;
        cArray[32] = 32;
        this.s2ch(string3, cArray, 33);
        return cArray;
    }

    void s2ch(String string, char[] cArray, int n) {
        int n2 = 0;
        for (int i = n; i < 80 && i < string.length() + n; ++i) {
            cArray[i] = string.charAt(n2++);
        }
    }

    void appendFile(char[] cArray, String string) {
        try {
            FileWriter fileWriter = new FileWriter(string, true);
            fileWriter.write(cArray);
            fileWriter.close();
        }
        catch (IOException iOException) {
            IJ.showStatus("Error writing file!");
            return;
        }
    }

    void writeData(String string, ImageProcessor imageProcessor) {
        int n = imageProcessor.getWidth();
        int n2 = imageProcessor.getHeight();
        imageProcessor.flipVertical();
        if (imageProcessor instanceof ShortProcessor) {
            short[] sArray = (short[])imageProcessor.getPixels();
            try {
                DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(string, true)));
                for (int i = 0; i < sArray.length; ++i) {
                    dataOutputStream.writeShort(sArray[i]);
                }
                dataOutputStream.close();
            }
            catch (IOException iOException) {
                IJ.write("Error writing file!");
                return;
            }
        }
        if (imageProcessor instanceof FloatProcessor) {
            float[] fArray = (float[])imageProcessor.getPixels();
            try {
                DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(string, true)));
                for (int i = 0; i < fArray.length; ++i) {
                    dataOutputStream.writeFloat(fArray[i]);
                }
                dataOutputStream.close();
            }
            catch (IOException iOException) {
                IJ.write("Error writing file!");
                return;
            }
        }
        imageProcessor.flipVertical();
    }

    public static String[] getHeader(ImagePlus imagePlus) {
        String string;
        int n;
        int n2;
        String[] stringArray;
        String string2 = null;
        int n3 = imagePlus.getStackSize();
        if (n3 == 1) {
            stringArray = imagePlus.getProperties();
            if (stringArray == null) {
                return null;
            }
            string2 = stringArray.getProperty("Info");
        } else if (n3 > 1) {
            int n4 = imagePlus.getCurrentSlice();
            ImageStack imageStack = imagePlus.getStack();
            string2 = imageStack.getSliceLabel(n4);
        }
        if (string2 == null) {
            return null;
        }
        stringArray = string2.split("\n");
        for (n2 = 0; n2 < stringArray.length && !stringArray[n2].startsWith("SIMPLE"); ++n2) {
        }
        if (n2 == stringArray.length) {
            return null;
        }
        for (n = n2 + 1; n < stringArray.length && !(string = stringArray[n].trim()).equals("END") && !string.startsWith("END "); ++n) {
        }
        if (n >= stringArray.length) {
            return null;
        }
        int n5 = n - n2 + 1;
        String string3 = "";
        for (int i = 0; i < n5; ++i) {
            string3 = string3 + stringArray[n2 + i] + "\n";
        }
        return string3.split("\n");
    }

    char[] eighty(String string) {
        char[] cArray = new char[80];
        int n = string.length();
        for (int i = 0; i < n && i < 80; ++i) {
            cArray[i] = string.charAt(i);
        }
        if (n < 80) {
            while (n < 80) {
                cArray[n] = 32;
                ++n;
            }
        }
        return cArray;
    }

    void copyHeader(String[] stringArray, String string, ImageProcessor imageProcessor, int n) {
        Object object;
        int n2;
        int n3 = 5;
        String string2 = "";
        if (n == 2) {
            string2 = "                  16";
        } else if (n == 4) {
            string2 = "                 -32";
        } else if (n == 1) {
            string2 = "                   8";
        }
        this.appendFile(this.writeCard("SIMPLE", "                   T", "Created by ImageJ FITS_Writer 2008-12-15"), string);
        this.appendFile(this.writeCard("BITPIX", string2, ""), string);
        this.appendFile(this.writeCard("NAXIS", "                   2", ""), string);
        this.appendFile(this.writeCard("NAXIS1", "                 " + imageProcessor.getWidth(), "image width"), string);
        this.appendFile(this.writeCard("NAXIS2", "                 " + imageProcessor.getHeight(), "image height"), string);
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            object = stringArray[n2];
            char[] cArray = this.eighty((String)object);
            if (((String)object).startsWith("SIMPLE") || ((String)object).startsWith("BITPIX") || ((String)object).startsWith("NAXIS") || ((String)object).startsWith("END ") || ((String)object).trim().length() <= 1) continue;
            this.appendFile(cArray, string);
            ++n3;
        }
        n2 = 2880 - (n3 * 80 + 3) % 2880;
        object = new char[3];
        object[0] = 69;
        object[1] = 78;
        object[2] = 68;
        char[] cArray = new char[n2];
        for (int i = 0; i < n2; ++i) {
            cArray[i] = 32;
        }
        this.appendFile((char[])object, string);
        this.appendFile(cArray, string);
    }
}

