% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/code_section.R
\name{code_section}
\alias{code_section}
\title{Pascal script to check registry for R}
\usage{
code_section(iss, R_version = paste0(">=", R.version$major, ".",
  R.version$minor))
}
\arguments{
\item{iss}{Character vector which cumulatively becomes an Inno Setup Script (ISS).}

\item{R_version}{R version to use. Supports inequalities similar to \code{pkgs}. Defaults to: \code{paste0(">=", R.version$major, '.', R.version$minor)}.}
}
\value{
Chainable character vector, which can be used as the \code{text} argument of \code{\link{writeLines}} to generate an ISS.
}
\description{
Modern Delphi-like Pascal adds a lot of customization possibilities to the
installer. For examples, please visit \href{http://www.jrsoftware.org/ishelp/topic_scriptintro.htm}{Pascal Scripting Introduction}.
}
\details{
This script checks the registry for R, so that R will only be installed if necessary.
}
\examples{
\dontrun{
readLines(system.file('installation/code.iss', package = 'RInno'))
}

}
\seealso{
\code{\link{get_R}}, \code{\link{copy_installation}}, \code{\link{create_config}}, \code{\link{create_bat}}, \code{\link{directives_section}}, \code{\link{setup_section}}, \code{\link{languages_section}}, \code{\link{tasks_section}}, \code{\link{files_section}}, \code{\link{icons_section}}, \code{\link{run_section}}, and \code{\link{code_section}}.
}
\author{
Jonathan M. Hill
}
