/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.eco;

import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.eco.ConcentratedLikelihood;
import ec.tstoolkit.eco.DiffuseLikelihood;
import ec.tstoolkit.maths.matrices.Matrix;

public class DiffuseConcentratedLikelihood
extends DiffuseLikelihood {
    private double[] m_b;
    private Matrix m_bvar;
    private int m_nx;

    public double bser(int idx, boolean unbiased, int hpcount) {
        if (unbiased) {
            double n = this.getN() - this.getD();
            double c = n / (n - (double)this.m_nx - (double)hpcount);
            return Math.sqrt(this.m_bvar.get(idx, idx) * c);
        }
        return Math.sqrt(this.m_bvar.get(idx, idx));
    }

    public int getDegreesOfFreedom(boolean unbiased, int hpcount) {
        int n = this.getN();
        if (unbiased) {
            n -= this.m_nx + hpcount;
        }
        return n;
    }

    public Matrix bvar() {
        return this.m_bvar.clone();
    }

    public Matrix bvar(boolean unbiased, int hpcount) {
        if (unbiased) {
            double n = this.getN() - this.getD();
            double c = n / (n - (double)this.m_nx - (double)hpcount);
            return this.m_bvar.times(c);
        }
        return this.m_bvar.clone();
    }

    public double[] getB() {
        return this.m_b;
    }

    public int getNx() {
        return this.m_nx;
    }

    public void rescale(double yfactor, double[] xfactor) {
        super.rescale(yfactor);
        if (this.m_b == null || xfactor == null) {
            return;
        }
        for (int i = 0; i < this.m_b.length; ++i) {
            double ifactor = xfactor[i] / yfactor;
            int n = i;
            this.m_b[n] = this.m_b[n] * ifactor;
            for (int j = 0; j < i; ++j) {
                double ijfactor = ifactor * xfactor[j] / yfactor;
                this.m_bvar.mul(i, j, ijfactor);
                this.m_bvar.mul(j, i, ijfactor);
            }
            this.m_bvar.mul(i, i, ifactor * ifactor);
        }
    }

    @Override
    public void rescale(double yfactor) {
        super.rescale(yfactor);
        if (this.m_b == null) {
            return;
        }
        int i = 0;
        while (i < this.m_b.length) {
            int n = i++;
            this.m_b[n] = this.m_b[n] / yfactor;
        }
        double yfactor2 = yfactor * yfactor;
        this.m_bvar.mul(1.0 / yfactor2);
    }

    public void setB(double[] b, Matrix bvar, int nx) {
        this.m_b = (double[])b.clone();
        this.m_bvar = bvar.clone();
        this.m_nx = nx;
    }

    public double[] tstats() {
        return this.tstats(false, 0);
    }

    public double[] tstats(boolean unbiased, int hpcount) {
        double c = 1.0;
        if (unbiased) {
            double n = this.getN() - this.getD();
            c = n / (n - (double)this.m_nx - (double)hpcount);
        }
        DataBlock diag = this.m_bvar.diagonal();
        double[] t = new double[diag.getLength()];
        for (int i = 0; i < t.length; ++i) {
            t[i] = this.m_b[i] / Math.sqrt(c * diag.get(i));
        }
        return t;
    }

    public double getTStat(int idx, boolean unbiased, int hpcount) {
        double e = this.m_bvar.get(idx, idx);
        if (e == 0.0) {
            return Double.NaN;
        }
        double b = this.m_b[idx];
        if (b == 0.0) {
            return 0.0;
        }
        if (unbiased) {
            double n = this.getN();
            return b / Math.sqrt(e * n / (n - (double)this.m_nx - (double)hpcount));
        }
        return b / Math.sqrt(e);
    }

    public ConcentratedLikelihood toConcentratedLikelihood() {
        ConcentratedLikelihood ll = new ConcentratedLikelihood();
        ll.set(this.getSsqErr(), this.getLogDeterminant() + this.getDiffuseLogDeterminant(), this.getN() - this.getD());
        ll.setB(this.m_b, this.m_bvar, this.m_nx);
        ll.setRes(this.getResiduals());
        return ll;
    }
}

