/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.timeseries.simplets.chainlinking;

import ec.tstoolkit.information.InformationSet;
import ec.tstoolkit.timeseries.simplets.TsData;
import java.util.ArrayList;
import java.util.List;

public abstract class AChainLinking {
    protected int refYear;
    protected List<Product> input;
    protected InformationSet results;

    public void addProduct(Product p) {
        if (this.input == null) {
            this.input = new ArrayList<Product>();
        }
        this.input.add(p);
    }

    public void setProducts(List<Product> products) {
        this.input = products == null ? new ArrayList<Product>() : products;
    }

    public void addProduct(String name, TsData q, TsData p) {
        this.addProduct(new Product(name, q, p, null));
    }

    public List<Product> getInput() {
        return this.input;
    }

    public InformationSet getResults() {
        return this.results;
    }

    public abstract void process();

    public int getRefYear() {
        return this.refYear;
    }

    public void setRefYear(int refYear) {
        this.refYear = refYear;
    }

    public static class Product {
        private String name;
        private TsData quantities;
        private TsData price;
        private TsData value;

        public Product(String n, TsData q, TsData p, TsData v) {
            this.name = n;
            this.quantities = q;
            this.price = p;
            this.value = v;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public TsData getQuantities() {
            return this.quantities;
        }

        public void setQuantities(TsData quantities) {
            this.quantities = quantities;
        }

        public TsData getPrice() {
            return this.price;
        }

        public void setPrice(TsData price) {
            this.price = price;
        }

        public TsData getValue() {
            return this.value;
        }

        public void setValue(TsData value) {
            this.value = value;
        }

        public void calculateMissingTs() {
            if (this.value == null) {
                this.value = TsData.multiply(this.quantities, this.price);
            } else if (this.quantities == null) {
                this.quantities = TsData.divide(this.value, this.price);
            } else if (this.price == null) {
                this.price = TsData.divide(this.value, this.quantities);
            }
        }

        protected Object clone() throws CloneNotSupportedException {
            return new Product(this.name, this.quantities.clone(), this.price.clone(), this.value.clone());
        }
    }

    public static enum ChainLinkingMethod {
        ANNUAL_OVERLAP,
        OVER_THE_YEAR;

    }
}

